<?php

if ( ! function_exists( 'blomma_select_map_post_video_meta' ) ) {
	function blomma_select_map_post_video_meta() {
		$video_post_format_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'blomma' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'blomma' ),
				'description'   => esc_html__( 'Choose video type', 'blomma' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'blomma' ),
					'self'            => esc_html__( 'Self Hosted', 'blomma' )
				)
			)
		);
		
		$qodef_video_embedded_container = blomma_select_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'qodef_video_embedded_container'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'blomma' ),
				'description' => esc_html__( 'Enter Video URL', 'blomma' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'blomma' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'blomma' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'blomma' ),
				'description' => esc_html__( 'Enter video image', 'blomma' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_post_video_meta', 22 );
}