<?php

if ( ! function_exists( 'blomma_select_register_sidebars' ) ) {
	/**
	 * Function that registers theme's sidebars
	 */
	function blomma_select_register_sidebars() {
		
		register_sidebar(
			array(
				'id'            => 'sidebar',
				'name'          => esc_html__( 'Sidebar', 'blomma' ),
				'description'   => esc_html__( 'Default Sidebar area. In order to display this area you need to enable it through global theme options or on page meta box options.', 'blomma' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="qodef-widget-title-holder"><h5 class="qodef-widget-title">',
				'after_title'   => '</h5></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'blomma_select_register_sidebars', 1 );
}

if ( ! function_exists( 'blomma_select_add_support_custom_sidebar' ) ) {
	/**
	 * Function that adds theme support for custom sidebars. It also creates BlommaSelectClassSidebar object
	 */
	function blomma_select_add_support_custom_sidebar() {
		add_theme_support( 'BlommaSelectClassSidebar' );
		
		if ( get_theme_support( 'BlommaSelectClassSidebar' ) ) {
			new BlommaSelectClassSidebar();
		}
	}
	
	add_action( 'after_setup_theme', 'blomma_select_add_support_custom_sidebar' );
}