(function($) {
    'use strict';

    var portfolio = {};
    qodef.modules.portfolio = portfolio;
	
    portfolio.qodefOnWindowLoad = qodefOnWindowLoad;
	
    $(window).on('load', qodefOnWindowLoad);
	
	/*
	 All functions to be called on $(window).on('load', ) should be in this function
	 */
	function qodefOnWindowLoad() {
		qodefPortfolioSingleFollow().init();
		qodefPortfolioFullScreenSlider().init();
		qodefPortfolioSingleStick().init();
		
	}
	
	/* Portfolio Single Split*/
	var qodefPortfolioSingleStick = function(){
		var portfolioSplit = $('.qodef-portfolio-single-holder.split-screen');
		var info = $('.qodef-follow-portfolio-info .split-screen.qodef-portfolio-single-holder .qodef-portfolio-info-holder');
		if (info.length && qodef.htmlEl.hasClass('no-touch')) {
			var infoHolder = info.parent(),
				infoHolderOffset = infoHolder.offset().top,
				infoHolderHeight = info.outerHeight() + 100, //30 is some default margin
				mediaHolder = $('.qodef-portfolio-media'),
				mediaHolderHeight = mediaHolder.height(),
				header = $('.qodef-page-header'),
				fixedHeader = header.find('.qodef-fixed-wrapper'),
				headerHeight = (header.length) ? header.height() : 0,
				fixedHeaderHeight = (fixedHeader.length) ? fixedHeader.height() : 0,
				infoHolderOffsetAfterScroll = headerHeight + 15; //15 is some default margin
			
		}
		
		var infoWidth = function() {
			if(info.length && qodef.htmlEl.hasClass('no-touch')){
				info.css('width',info.width());
			}
		};
		
		
		var initInfoHolder = function(){
			if(info.length && qodef.htmlEl.hasClass('no-touch')){
				var stickyActive = header.find('.qodef-sticky-header');
				if (stickyActive.length){
					if (!stickyActive.hasClass('header-appear')){
						var headerVisible = (headerHeight - qodef.scroll) > 0 ? true : false;
						if (headerVisible){
							infoHolderOffsetAfterScroll = qodefGlobalVars.vars.qodefAddForAdminBar + headerHeight - 5; // 5 is designer wishes
						}
						else{
							infoHolderOffsetAfterScroll = 24;
						}
					}
					else{
						infoHolderOffsetAfterScroll = qodefGlobalVars.vars.qodefStickyHeaderTransparencyHeight + qodefGlobalVars.vars.qodefAddForAdminBar + 15;
					}
				}
				else if (fixedHeader.length){
					infoHolderOffsetAfterScroll = qodefGlobalVars.vars.qodefAddForAdminBar + fixedHeaderHeight + 15; // 5 is designer wishes
				}
				if(info.length && mediaHolderHeight > infoHolderHeight && qodef.htmlEl.hasClass('no-touch')) {
					info.css('top',infoHolderOffsetAfterScroll+'px');
				}
			}
		};
		
		var calcInfoHolderPosition = function(){
			if(info.length && qodef.htmlEl.hasClass('no-touch')){
				infoHolderHeight = info.outerHeight() + 30;
				mediaHolderHeight = mediaHolder.height();
				
				if(mediaHolderHeight > infoHolderHeight && qodef.htmlEl.hasClass('no-touch')) {
					if (fixedHeader.length){
						headerHeight = fixedHeaderHeight;
					}
					if(qodef.scroll >= infoHolderOffset - headerHeight - qodefGlobalVars.vars.qodefAddForAdminBar){
						if (info.css('position') !== 'fixed'){
							info.css('position','fixed');
							if (qodef.scroll > 0) {
								info.addClass('qodef-animating');
								info.one('webkitAnimationEnd oanimationend msAnimationEnd animationend', function(){
									info.removeClass('qodef-animating');
								});
							}
						}
					}else{
						info.css('position','static');
					}
					
					if(infoHolderOffset+mediaHolderHeight<=qodef.scroll+infoHolderHeight + infoHolderOffsetAfterScroll){
						info.stop().css('margin-top',infoHolderOffset + mediaHolderHeight - qodef.scroll - infoHolderHeight - infoHolderOffsetAfterScroll+'px');
					}else{
						info.css('margin-top','0');
					}
				}
				if (!info.hasClass('qodef-appeared')){
					info.addClass('qodef-appeared');
				}
			}
			else if (qodef.htmlEl.hasClass('touch')){
				if (!info.hasClass('qodef-appeared')){
					info.addClass('qodef-appeared');
				}
			}
		};
		
		return {
			init: function(){
				if (portfolioSplit.length){
					infoWidth();
					calcInfoHolderPosition();
					initInfoHolder();
					$(window).scroll(function(){
						calcInfoHolderPosition();
						initInfoHolder();
					});
					$(window).resize(function(){
						initInfoHolder();
						calcInfoHolderPosition();
					});
				}
			}
		};
	};
	
	var qodefPortfolioSingleFollow = function () {
		var info = $('.qodef-follow-portfolio-info .qodef-portfolio-single-holder .qodef-ps-info-sticky-holder');
		
		if (info.length) {
			var infoHolder = info.parent(),
				infoHolderOffset = infoHolder.offset().top,
				infoHolderHeight = infoHolder.height(),
				mediaHolder = $('.qodef-ps-image-holder'),
				mediaHolderHeight = mediaHolder.height(),
				header = $('.header-appear, .qodef-fixed-wrapper'),
				headerHeight = (header.length) ? header.height() : 0,
				constant = 30; //30 to prevent mispositioned
		}
		
		var infoHolderPosition = function () {
			if (info.length && mediaHolderHeight >= infoHolderHeight) {
				if (qodef.scroll >= infoHolderOffset - headerHeight - qodefGlobalVars.vars.qodefAddForAdminBar - constant) {
					var marginTop = qodef.scroll - infoHolderOffset + qodefGlobalVars.vars.qodefAddForAdminBar + headerHeight + constant;
					// if scroll is initially positioned below mediaHolderHeight
					if (marginTop + infoHolderHeight > mediaHolderHeight) {
						marginTop = mediaHolderHeight - infoHolderHeight + constant;
					}
					info.stop().animate({
						marginTop: marginTop
					});
				}
			}
		};
		
		var recalculateInfoHolderPosition = function () {
			if (info.length && mediaHolderHeight >= infoHolderHeight) {
				//Calculate header height if header appears
				if (qodef.scroll > 0 && header.length) {
					headerHeight = header.height();
				}
				
				var headerMixin = headerHeight + qodefGlobalVars.vars.qodefAddForAdminBar + constant;
				if (qodef.scroll >= infoHolderOffset - headerMixin) {
					if (qodef.scroll + infoHolderHeight + headerMixin + 2 * constant < infoHolderOffset + mediaHolderHeight) {
						info.stop().animate({
							marginTop: (qodef.scroll - infoHolderOffset + headerMixin + 2 * constant)
						});
						//Reset header height
						headerHeight = 0;
					} else {
						info.stop().animate({
							marginTop: mediaHolderHeight - infoHolderHeight
						});
					}
				} else {
					info.stop().animate({
						marginTop: 0
					});
				}
			}
		};
		
		return {
			init: function () {
				infoHolderPosition();
				$(window).scroll(function () {
					recalculateInfoHolderPosition();
				});
			}
		};
	};
	
	/**
	 * Init Full Screen Slider
	 */
	var qodefPortfolioFullScreenSlider = function() {
		
		var sliderHolder = $('.qodef-full-screen-slider-holder');
		var content = $('.qodef-wrapper .qodef-content');
		
		var sliders = $('.qodef-portfolio-full-screen-slider');
		var fullScreenSliderHolder = $('.qodef-ps-full-screen-slider-layout');
		
		var qodefFullScreenSliderHeight = function() {
			if (sliderHolder.length) {
				
				var contentMargin = parseInt(content.css('margin-top')),
					imageHolder = sliderHolder.find('.qodef-portfolio-single-media'),
					title = $('.qodef-title'),
					paspartuHeight = 0,
					sliderHeight = qodef.windowHeight;
				
				
				if (qodef.body.hasClass('qodef-passepartout')){
					var paspartu = $('.qodef-passepartout-top');
					
					paspartuHeight = paspartu.outerHeight() * 2;
					sliderHeight -= paspartuHeight;
				}
				
				if (title.length){
					sliderHeight -= title.height();
				}
				
				if(qodef.windowWidth > 1024) {
					if(contentMargin >= 0) {
						sliderHeight -= qodefGlobalVars.vars.qodefMenuAreaHeight;
					}
				}
				else {
					sliderHeight -= qodefGlobalVars.vars.qodefMobileHeaderHeight;
				}
				
				fullScreenSliderHolder.css("height", sliderHeight);
				sliderHolder.css("height", sliderHeight);
				imageHolder.css("height", sliderHeight);
			}
		};
		
		var qodefFullScreenSlider = function() {
			
			if (sliderHolder.length) {
				sliders.each(function () {
					var slider = $(this);
					
					
					slider.on('init', function(slick){
						var activeSlide = slider.find('.slick-active.qodef-portfolio-single-media');
						if(activeSlide.hasClass('qodef-slide-dark-skin')){
							slider.removeClass('qodef-slide-light-skin').addClass('qodef-slide-dark-skin');
						}else{
							slider.removeClass('qodef-slide-dark-skin').addClass('qodef-slide-light-skin');
						}
					});
					
					slider.on('afterChange', function(slick, currentSlide){
						var activeSlide = slider.find('.slick-active.qodef-portfolio-single-media');
						if(activeSlide.hasClass('qodef-slide-dark-skin')){
							slider.removeClass('qodef-slide-light-skin').addClass('qodef-slide-dark-skin');
						}else{
							slider.removeClass('qodef-slide-dark-skin').addClass('qodef-slide-light-skin');
						}
					});
					
					slider.slick({
						vertical: true,
						verticalSwiping: true,
						infinite: true,
						slidesToShow : 1,
						arrows: true,
						dots: false,
						easing: 'easeOutQuart',
						dotsClass: 'qodef-slick-dots',
						prevArrow: '<span class="qodef-slick-prev qodef-prev-icon"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n' +
						'  width="14px" height="72px" viewBox="0 0 14 72" enable-background="new 0 0 14 72" xml:space="preserve">\n' +
						'<g>\n' +
						' <defs>\n' +
						'  <rect id="SVGID_1_" width="14" height="72"/>\n' +
						' </defs>\n' +
						' <clipPath id="SVGID_2_">\n' +
						'  <use xlink:href="#SVGID_1_"  overflow="visible"/>\n' +
						' </clipPath>\n' +
						' \n' +
						'  <line clip-path="url(#SVGID_2_)" fill="none" stroke="#FFFFFF" stroke-width="0.991" stroke-miterlimit="10" x1="7" y1="71" x2="7" y2="1"/>\n' +
						' <polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#FFFFFF" stroke-miterlimit="10" points="0.636,7.364 7,1 13.364,7.364  \n' +
						'  "/>\n' +
						'</g>\n' +
						'</svg></span>',
						nextArrow: '<span class="qodef-slick-next qodef-prev-icon"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"\n' +
						'  width="14px" height="72px" viewBox="0 0 14 72" enable-background="new 0 0 14 72" xml:space="preserve">\n' +
						'<g>\n' +
						' <defs>\n' +
						'  <rect id="SVGID_1_" width="14" height="72"/>\n' +
						' </defs>\n' +
						' <clipPath id="SVGID_2_">\n' +
						'  <use xlink:href="#SVGID_1_"  overflow="visible"/>\n' +
						' </clipPath>\n' +
						' \n' +
						'  <line clip-path="url(#SVGID_2_)" fill="none" stroke="#FFFFFF" stroke-width="0.991" stroke-miterlimit="10" x1="7" y1="1" x2="7" y2="71"/>\n' +
						' <polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#FFFFFF" stroke-miterlimit="10" points="13.364,64.636 7,71 \n' +
						'  0.636,64.636  "/>\n' +
						'</g>\n' +
						'</svg></span>',
						customPaging: function(slider, i) {
							return '<span class="qodef-slick-dot-inner"></span>';
						}
					}).animate({'opacity': 1}, 600);
				});
			}
			
		};
		
		var qodefFullScreenSliderInfo = function() {
			
			if (sliderHolder.length) {
				
				var sliderContent = $('.qodef-portfolio-slider-content');
				var close = $('.qodef-control.qodef-close');
				var description = $('.qodef-description');
				var info = $('.qodef-portfolio-slider-content-info');
				
				sliderContent.on('click',function(e){
					e.preventDefault();
					if (!sliderContent.hasClass('opened')) {
						description.fadeOut(400, function() {
							sliderContent.addClass('opened');
							setTimeout(function(){
								info.fadeIn(400);
							}, 400);
							setTimeout(function(){
								$(".qodef-portfolio-slider-content-info").niceScroll({
									scrollspeed: 60,
									mousescrollstep: 40,
									cursorwidth: 0,
									cursorborder: 0,
									cursorborderradius: 0,
									cursorcolor: "transparent",
									autohidemode: false,
									horizrailenabled: false
								});
							}, 800);
						});
					}
				});
				
				close.on('click',function(e){
					e.preventDefault();
					e.stopPropagation();
					info.fadeOut( 400, function() {
						sliderContent.removeClass('opened');
						setTimeout(function() {
							description.fadeIn(400);
						}, 400);
					});
				});
				
			}
			
		};
		return {
			init : function() {
				qodefFullScreenSliderHeight();
				qodefFullScreenSlider();
				qodefFullScreenSliderInfo();
				
				$(window).resize(function(){
					qodefFullScreenSliderHeight();
				});
			}
		};
	};

})(jQuery);