(function($) {
	'use strict';
	
	var portfolio = {};
	qodef.modules.portfolio = portfolio;
	
	portfolio.qodefOnDocumentReady = qodefOnDocumentReady;
	portfolio.qodefOnWindowLoad = qodefOnWindowLoad;
	portfolio.qodefOnWindowResize = qodefOnWindowResize;
	portfolio.qodefOnWindowScroll = qodefOnWindowScroll;
	
	$(document).ready(qodefOnDocumentReady);
	$(window).on('load', qodefOnWindowLoad);
	$(window).resize(qodefOnWindowResize);
	$(window).scroll(qodefOnWindowScroll);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefPortfolioSection();
	}
	
	/*
	 All functions to be called on $(window).on('load', ) should be in this function
	 */
	function qodefOnWindowLoad() {
		qodefPortfolioFullscreenGrid();
		qodefPortfolioFullscreenGridSize();
		qodefPortfolioFullscreenSlider();
	}
	
	/*
	 All functions to be called on $(window).resize() should be in this function
	 */
	function qodefOnWindowResize() {
		qodefPortfolioFullscreenGridSize();
	}
	
	/*
	 All functions to be called on $(window).scroll() should be in this function
	 */
	function qodefOnWindowScroll() {
	}
	
	/**
	 * Initializes portfolio list article animation
	 */
	function qodefInitPortfolioListAnimation(){
		var portList = $('.qodef-portfolio-list-holder.qodef-pl-has-animation');
		
		if(portList.length){
			portList.each(function(){
				var thisPortList = $(this).children('.qodef-pl-inner');
				
				thisPortList.children('article').each(function(l) {
					var thisArticle = $(this);
					
					thisArticle.appear(function() {
						thisArticle.addClass('qodef-item-show');
						
						setTimeout(function(){
							thisArticle.addClass('qodef-item-shown');
						}, 1000);
					},{accX: 0, accY: 0});
				});
			});
		}
	}
	
	/**
	 * Init Resize Portfolio Items
	 */
	function qodefResizePortfolioItems(size,container){
		if(container.hasClass('qodef-pl-images-fixed')) {
			var padding = parseInt(container.find('article').css('padding-left')),
				defaultMasonryItem = container.find('.qodef-pl-masonry-default'),
				largeWidthMasonryItem = container.find('.qodef-pl-masonry-large-width'),
				largeHeightMasonryItem = container.find('.qodef-pl-masonry-large-height'),
				largeWidthHeightMasonryItem = container.find('.qodef-pl-masonry-large-width-height');
			
			if (qodef.windowWidth > 680) {
				defaultMasonryItem.css('height', size - 2 * padding);
				largeHeightMasonryItem.css('height', Math.round(2 * size) - 2 * padding);
				largeWidthHeightMasonryItem.css('height', Math.round(2 * size) - 2 * padding);
				largeWidthMasonryItem.css('height', size - 2 * padding);
			} else {
				defaultMasonryItem.css('height', size);
				largeHeightMasonryItem.css('height', size);
				largeWidthHeightMasonryItem.css('height', size);
				largeWidthMasonryItem.css('height', Math.round(size / 2));
			}
		}
	}
	
	function qodefPortfolioFullscreenGrid(){
		var fullscreenGrid = $('.qodef-fullscreen-portfolio-grid-holder');
		
		if (fullscreenGrid.length){
			fullscreenGrid.each(function () {
				var thisGrid = $(this),
					articles = thisGrid.find('.qodef-fpg-item'),
					articlesLink = thisGrid.find('.qodef-fpgi-link'),
					articlesImages = thisGrid.find('.qodef-fpg-image-holder .qodef-image-url-holder-inner');
				
				
				articles.eq(0).addClass('hovered');
				articlesImages.eq(0).addClass('hovered');
				
				//remove first click when on touch devices - go to link on second click
				if(qodef.htmlEl.hasClass('touch')){
					articlesLink.eq(0).addClass('active');
					
					articlesLink.each(function () {
						var link = $(this);
						
						link.on('click', function(e){
							if (!link.hasClass('active')) {
								e.preventDefault();
								articlesLink.removeClass('active');
								link.addClass('active');
							}
							
						});
					});
				}
				
				articles.each(function(e){
					var thisArticle = $(this);
					
					thisArticle.on('mouseover', function () {
						
						var imageHolder = articlesImages.eq(e);
						
						if (!thisArticle.hasClass('hovered')){
							thisArticle.siblings().removeClass('hovered');
							imageHolder.siblings().removeClass('hovered');
							
							thisArticle.addClass('hovered');
							imageHolder.addClass('hovered');
						}
					});
				});
				
			});
		}
	}
	
	function qodefPortfolioFullscreenGridSize(){
		var fullscreenGrid = $('.qodef-fullscreen-portfolio-grid-holder');
		
		if (fullscreenGrid.length){
			fullscreenGrid.each(function () {
				var thisGrid = $(this),
					thisGridHeight,
					articlesHolder = thisGrid.find('.qodef-fpg-holder-inner'),
					articles = thisGrid.find('.qodef-fpg-item'),
					columns,
					postsNumber,
					numberOfRows,
					articleHeight,
					mobileHeaderHeight = $('.qodef-mobile-header').height();
				
				
				if(qodef.htmlEl.hasClass('touch')){
					thisGrid.css('height','calc(100vh - '+mobileHeaderHeight+'px)');
				}
				
				thisGridHeight = thisGrid.height();
				
				if (typeof thisGrid.data('col-number') !== 'undefined' && thisGrid.data('col-number') !== ''){
					columns = thisGrid.data('col-number');
				}
				
				if (typeof thisGrid.data('number-of-posts') !== 'undefined' && thisGrid.data('number-of-posts') !== ''){
					postsNumber = thisGrid.data('number-of-posts');
				}
				
				if (qodef.windowWidth <= 480){
					columns = 1;
				} else if (qodef.windowWidth <= 768){
					if (columns > 2){
						columns = 2;
					}
				}
				
				if (postsNumber !== 0){
					numberOfRows = Math.ceil(postsNumber/columns);
				}
				
				articleHeight = thisGridHeight/numberOfRows;
				
				if (qodef.windowWidth <= 480){
					articleHeight = 'auto';
				}
				
				articles.each(function(e){
					var thisArticle = $(this);
					
					thisArticle.height(articleHeight);
				});
				
				//2px is for rounding of px
				if (articlesHolder.height() > thisGridHeight + 2){
					thisGrid.css('height','auto');
				}
				
				thisGrid.css('opacity',1);
				
			});
		}
	}
	
	function qodefPortfolioFullscreenSlider(){
		var fullscreenSliders = $('.qodef-portfolio-fullscreen-slider-holder');
		
		if (fullscreenSliders.length){
			fullscreenSliders.each(function () {
				var thisSlider = $(this),
					articles = thisSlider.find('.qodef-pfs-item'),
					articlesLink = thisSlider.find('.qodef-pfs-link'),
					articlesImages = thisSlider.find('.qodef-pfs-image-holder .qodef-pfs-image-holder-item'),
					articlesHolder = thisSlider.find('.qodef-pfs-articles-holder'),
					swiperInstance = thisSlider.find('.swiper-container'),
					direction = 'vertical',
					loop = false,
					wheel = true,
					slideSpeed = 600,
					slidesOffsetBefore = 0,
					mobileHeaderHeight = $('.qodef-mobile-header').height();
				
				
				articles.eq(0).addClass('hovered');
				articlesImages.eq(0).addClass('hovered');
				
				//remove first click when on touch devices - go to link on second click
				if(qodef.htmlEl.hasClass('touch')){
					articlesLink.eq(0).addClass('active');
					
					articlesLink.each(function () {
						var link = $(this);
						
						link.on('click', function(e){
							if (!link.hasClass('active')) {
								e.preventDefault();
								articlesLink.removeClass('active');
								link.addClass('active');
							}
						});
					});
				}
				
				articles.each(function(e){
					var thisArticle = $(this);
					
					thisArticle.on('mouseover', function () {
						var imageHolder = articlesImages.eq(e);
						
						if (!thisArticle.hasClass('hovered')){
							thisArticle.siblings().removeClass('hovered');
							imageHolder.siblings().removeClass('hovered');
							
							thisArticle.addClass('hovered');
							imageHolder.addClass('hovered');
						}
					});
				});
				
				if(qodef.htmlEl.hasClass('touch')){
					thisSlider.css('height','calc(100vh - '+mobileHeaderHeight+'px)');
				}
				
				slidesOffsetBefore = -qodef.windowHeight * 0.3;
				
				if(qodef.windowWidth <= 1300) {
					slidesOffsetBefore = -qodef.windowHeight * 0.6;
				}
				
				if(qodef.windowWidth <= 1025) {
					slidesOffsetBefore = -qodef.windowHeight * 0.3;
				}
				
				if (qodef.htmlEl.hasClass('touch')) {
					
					articles.each(function(){
						$(this).css('min-height', $(this).outerHeight());
					})
				}
				
				//sliders
				var swiperSlider = new Swiper(swiperInstance, {
					loop: loop,
					initialSlide: 0,
					slidesOffsetBefore: slidesOffsetBefore,
					slidesPerView: 'auto',
					centeredSlides: true,
					speed: slideSpeed,
					direction: direction,
					mousewheelControl: wheel,
					preventClicks: true,
					preventClicksPropagation: false,
					onInit: function() {
						thisSlider.addClass('qodef-initialized');
					},
					onSlideChangeEnd: function(slider) {
						var lastSlide = articlesHolder.find('.qodef-pfs-item').last();
						
						if (lastSlide.offset().top + lastSlide.height() <= qodef.windowHeight) {
							slider.lockSwipeToNext();
						} else {
							slider.unlockSwipeToNext();
						}
					}
				});
				
			});
		}
	}
	
	
	function qodefPortfolioSection(){
		var portfolioSections = $('.qodef-portfolio-section-holder');
		
		if (portfolioSections.length){
			portfolioSections.each(function () {
				var thisSection = $(this),
					articles = thisSection.find('.qodef-section-item'),
					articlesLink = thisSection.find('.qodef-section-link'),
					articlesImages = thisSection.find('.qodef-portfolio-section-image-holder .qodef-image-url-holder-inner');
				
				
				articles.eq(0).addClass('hovered');
				articlesImages.eq(0).addClass('hovered');
				
				//remove first click when on touch devices - go to link on second click
				if(qodef.htmlEl.hasClass('touch')){
					articlesLink.eq(0).addClass('active');
					
					articlesLink.each(function () {
						var link = $(this);
						
						link.on('click', function(e){
							if (!link.hasClass('active')) {
								e.preventDefault();
								articlesLink.removeClass('active');
								link.addClass('active');
							}
							
						});
					});
				}
				
				articles.each(function(e){
					var thisArticle = $(this);
					
					thisArticle.on('mouseover', function () {
						
						var imageHolder = articlesImages.eq(e);
						
						if (!thisArticle.hasClass('hovered')){
							thisArticle.siblings().removeClass('hovered');
							imageHolder.siblings().removeClass('hovered');
							
							thisArticle.addClass('hovered');
							imageHolder.addClass('hovered');
						}
					});
				});
				
			});
		}
	}
	
})(jQuery);