<?php

if ( ! function_exists( 'blomma_core_map_testimonials_meta' ) ) {
	function blomma_core_map_testimonials_meta() {
		$testimonial_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'blomma-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'blomma-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'blomma-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'blomma-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'blomma-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'blomma-core' ),
				'description' => esc_html__( 'Enter author name', 'blomma-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'blomma-core' ),
				'description' => esc_html__( 'Enter author job position', 'blomma-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_core_map_testimonials_meta', 95 );
}