<?php
namespace BlommaCore\CPT\Shortcodes\imageMarquee;

use BlommaCore\Lib;

class imageMarquee implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'qodef_image_marquee';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Image Marquee', 'blomma-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by BLOMMA', 'blomma-core' ),
					'icon'                      => 'icon-wpb-image-marquee extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'       => 'dropdown',
							'param_name' => 'marquee_layout',
							'heading'    => esc_html__( 'Marquee Layout', 'blomma-core' ),
							'value'      => array(
								esc_html__( 'Default', 'blomma-core' )		=> 'default',
								esc_html__( 'Full Height', 'blomma-core' )	=> 'full-height'
							),
							'admin_label' => true,
							'group'			=> esc_html__( 'Marquee Options', 'blomma-core' )
						),
						array(
							'type'			=> 'attach_image',
							'param_name'	=> 'marquee_image',
							'heading'		=> esc_html__( 'Marquee Image', 'blomma-core' ),
							'description'	=> esc_html__( 'Select image from media library', 'blomma-core' ),
							'group'			=> esc_html__( 'Marquee Options', 'blomma-core' )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'marquee_layout'	=> 'default',
			'marquee_image' 	=> '',
		);
		
		$params = shortcode_atts( $args, $atts );

		$params['holder_classes'] 	= $this->getHolderClasses( $params, $args );

		$html = blomma_core_get_shortcode_module_template_part( 'templates/image-marquee-template', 'image-marquee', '', $params );
		
		return $html;
	}

	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['marquee_layout'] ) ? 'qodef-im-' . $params['marquee_layout'] : '';
		
		return implode( ' ', $holderClasses );
	}
}