(function($) {
	'use strict';
	
	var interactiveLinkShowcase = {};
	qodef.modules.interactiveLinkShowcase = interactiveLinkShowcase;
	
	interactiveLinkShowcase.qodefInitInteractiveLinkShowcase = qodefInitInteractiveLinkShowcase;
	
	
	interactiveLinkShowcase.qodefOnDocumentReady = qodefOnDocumentReady;
	interactiveLinkShowcase.qodefOnWindowResize = qodefOnWindowResize;
	
	$(document).ready(qodefOnDocumentReady);
	$(window).resize(qodefOnWindowResize);
	
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefInitInteractiveLinkShowcase();
	}
	
	/*
	 All functions to be called on $(window).resize() should be in this function
	 */
	function qodefOnWindowResize() {
		qodefInitInteractiveLinkShowcase();
	}
	
	/**
	 * Init item showcase shortcode
	 */
	function qodefInitInteractiveLinkShowcase() {
		var interactiveLinkShowcase = $('.qodef-ils-holder');
		
		if (interactiveLinkShowcase.length) {
			interactiveLinkShowcase.each(function(){
				var thisInteractiveLinkShowcase = $(this),
					singleImage = thisInteractiveLinkShowcase.find('.qodef-ils-item-image'),
					singleLink  = thisInteractiveLinkShowcase.find('.qodef-ils-item-title');
				
				singleImage.eq(0).addClass('qodef-active');
				singleLink.parent().removeClass('qodef-active').eq(0).addClass('qodef-active');
				//thisInteractiveLinkShowcase.find('.qodef-ils-item-link[data-index="0"]').addClass('qodef-active');
				
				singleLink.on('mouseenter', function() {
					var thisLink = $(this),
						index = thisLink.parent().index();
					
					singleImage.removeClass('qodef-active').eq(index).addClass('qodef-active');
					singleLink.parent().removeClass('qodef-active').eq(index).addClass('qodef-active');
				}).on('mouseleave', function() {
					//singleImage.removeClass('qodef-active');
					//singleLink.parent().removeClass('qodef-active');
					
				});
			});
		}
	}
	
})(jQuery);