(function($) {
	'use strict';
	
	var pieChart = {};
	qodef.modules.pieChart = pieChart;
	
	pieChart.qodefInitPieChart = qodefInitPieChart;
	
	
	pieChart.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefInitPieChart();
	}
	
	/**
	 * Init Pie Chart shortcode
	 */
	function qodefInitPieChart() {
		var pieChartHolder = $('.qodef-pie-chart-holder');
		
		if (pieChartHolder.length) {
			pieChartHolder.each(function () {
				var thisPieChartHolder = $(this),
					pieChart = thisPieChartHolder.children('.qodef-pc-percentage'),
					svg = pieChart.find('svg'),
					barColor = '#000000',
					trackColor = '#8ef8d2',
					lineWidth = 4,
					size = 177;
				
				if(typeof pieChart.data('size') !== 'undefined' && pieChart.data('size') !== '') {
					size = pieChart.data('size');
					if (size !==177) {
                    	pieChart.find('.qodef-pc-title').css({'top' : size/2});
                    }
				}
				
				if(typeof pieChart.data('bar-color') !== 'undefined' && pieChart.data('bar-color') !== '') {
					barColor = pieChart.data('bar-color');
				}
				
				if(typeof pieChart.data('track-color') !== 'undefined' && pieChart.data('track-color') !== '') {
					trackColor = pieChart.data('track-color');
				}
				
				pieChart.appear(function() {
					initToCounterPieChart(pieChart);
					thisPieChartHolder.css('opacity', '1');
					
					pieChart.easyPieChart({
						barColor: barColor,
						trackColor: false,
						scaleColor: false,
						lineCap: 'butt',
						lineWidth: lineWidth,
						animate: 1500,
						size: size
					});
				},{accX: 0, accY: qodefGlobalVars.vars.qodefElementAppearAmount});

				svg.css({'color' : trackColor, 'width' : '100%'});

                var glow = glowColor(barColor,40,.55);

                pieChart.find('canvas').css({
					'color' : glow
				});
			});
		}
	}
	
	/*
	 **	Counter for pie chart number from zero to defined number
	 */
    function initToCounterPieChart(pieChart) {
        var counter = pieChart.find('.qodef-pc-percent'),
            svg = pieChart.find('svg'),
            max = parseFloat(counter.text()),
            barColor = '#000000',
            i,
			resto = 24*max % 100,
            getDotNum = Math.floor(24/100 * max);

        	if(resto > 70) {
                getDotNum = Math.ceil(24/100 * max);
			}


        if (typeof pieChart.data('bar-color') !== 'undefined' && pieChart.data('bar-color') !== '') {
            barColor = pieChart.data('bar-color');
        }

        counter.countTo({
            from: 0,
            to: max,
            speed: 1500,
            refreshInterval: 50
        });

        svg.find(':last-child').css({'color': barColor});

        function delayedColorChange(i) {
            setTimeout(function () {
                svg.find(':nth-child(' + i + ')').css({'color': barColor});
            }, 100 + 50 * i);
        }

        for (i = 1; i <= getDotNum; i++) {
            delayedColorChange(i);
        }
    }

	//Get the glow color as a lighter version of the bar color
    function glowColor(color, percent, alpha) {

        var R = parseInt(color.substring(1,3),16);
        var G = parseInt(color.substring(3,5),16);
        var B = parseInt(color.substring(5,7),16);

        R = parseInt(R * (100 + percent) / 100);
        G = parseInt(G * (100 + percent) / 100);
        B = parseInt(B * (100 + percent) / 100);

        R = (R<255)?R:255;
        G = (G<255)?G:255;
        B = (B<255)?B:255;

		return 'rgba('+R+','+G+','+B+','+ alpha+')';
    }
	
})(jQuery);