<?php

if ( ! function_exists( 'blomma_select_portfolio_options_map' ) ) {
	function blomma_select_portfolio_options_map() {
		
		blomma_select_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'blomma-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = blomma_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'blomma-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'blomma-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'blomma-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'blomma-core' ),
				'default_value' => 'four',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is Four columns', 'blomma-core' ),
				'parent'        => $panel_archive,
				'options'       => blomma_select_get_number_of_columns_array( false, array( 'one', 'six' ) )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'blomma-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'blomma-core' ),
				'default_value' => 'normal',
				'options'       => blomma_select_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'blomma-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'blomma-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'blomma-core' ),
					'landscape' => esc_html__( 'Landscape', 'blomma-core' ),
					'portrait'  => esc_html__( 'Portrait', 'blomma-core' ),
					'square'    => esc_html__( 'Square', 'blomma-core' )
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'blomma-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'blomma-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader' => esc_html__( 'Standard - Shader', 'blomma-core' ),
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'blomma-core' )
				)
			)
		);
		
		$panel = blomma_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'blomma-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'blomma-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'blomma-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'blomma-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'blomma-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'blomma-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'blomma-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'blomma-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'blomma-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'blomma-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'blomma-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'blomma-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'blomma-core' ),
					'split-screen'      => esc_html__('Portfolio Split Screen','blomma-core'),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'blomma-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = blomma_select_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'blomma-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'blomma-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => blomma_select_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'blomma-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'blomma-core' ),
				'default_value' => 'normal',
				'options'       => blomma_select_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = blomma_select_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'blomma-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'blomma-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => blomma_select_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'blomma-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'blomma-core' ),
				'default_value' => 'normal',
				'options'       => blomma_select_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'blomma-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'blomma-core' ),
					'yes' => esc_html__( 'Yes', 'blomma-core' ),
					'no'  => esc_html__( 'No', 'blomma-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'blomma-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = blomma_select_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'blomma-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'blomma-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'blomma-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'blomma_select_action_options_map', 'blomma_select_portfolio_options_map', blomma_select_set_options_map_position( 'portfolio' ) );
}