(function ($) {
	'use strict';

	$(document).ready(qodefOnDocumentReady);

	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefSVGMorph();
	}

	/*
	 **	SVG Morph /w Snap.svg 
	 */
	function qodefSVGMorph() {
		var svgHolders = document.querySelectorAll('.qodef-svg-morph-holder'),
			loaderPresent = document.querySelector('.qodef-svg-morph-loader') !== null;

		if (svgHolders !== null) {
			var easing = mina.linear;

			var inView = function (element, offset) {
				var elementRect = element.getBoundingClientRect(),
					offsetVal = offset || 0,
					evaluate = window.innerHeight - offsetVal > elementRect.top && elementRect.height > -elementRect.top ? true : false;

				return evaluate;
			}

			var auxClass = function (element) {
				var setClass = function (element) {
					element.closest('.qodef-eh-item').classList.add('qodef-overflow-hidden');
				}

				element.closest('.qodef-eh-item') && setClass(element);
			}

			var positioning = function (element) {
				var setRelativeParent = function () {
					element.closest('.vc_row').style.position = "relative";
				}

				element.classList.toString().indexOf('absolute') >= 0 && setRelativeParent(element);
			}

			var show = function (element, i) {
				var delay = i < 3 ? i * 300 : 0;
				element.querySelector('svg').style.transitionDelay = delay + 'ms';

				var setClass = function () {
					inView(element.querySelector('svg'), 100) &&
						element.classList.toString().indexOf('qodef-appeared') < 0 &&
						element.classList.add('qodef-appeared');
				}

				window.addEventListener('scroll', function () {
					setClass();
				});

				setClass();
			}

			var toMorph = function (element, idle, points, i, speed) {
				var animating = false;

				var animateMorph = function () {
					animating = true;
					idle.animate({
						d: points[i]
					}, speed, easing, function () {
						i = i == 1 ? 0 : 1;

						requestAnimationFrame(function () {
							toMorph(element, idle, points, i, speed);
						});
					});
				}

				window.addEventListener('scroll', function () {
					inView(element.querySelector('svg')) && !animating && animateMorph();
				});

				inView(element.querySelector('svg')) && !animating && animateMorph();
			}

			for (var i = 0; i < svgHolders.length; i++) {
				var selector = svgHolders[i].getAttribute('id'),
					idle = Snap('#' + selector + ' svg > path:first-of-type'),
					morph = Snap('#' + selector + ' svg > path:last-of-type'),
					idlePoints = idle.node.getAttribute('d'),
					morphPoints = morph.node.getAttribute('d'),
					points = [morphPoints, idlePoints],
					speed = parseInt(svgHolders[i].getAttribute('data-speed')) || 4000;

				positioning(svgHolders[i]);
				auxClass(svgHolders[i]);
				toMorph(svgHolders[i], idle, points, 0, speed);

				//sync with loader
				if (!loaderPresent) {
					show(svgHolders[i], i);
				} else {
					(function(index) {
						$(document).on('qodefLoaderRemoved', function() {
							show(svgHolders[index], index);
						});
					})(i);
				}
			}
		}

	}

})(jQuery);