<?php

if ( ! function_exists( 'blomma_select_map_general_meta' ) ) {
	function blomma_select_map_general_meta() {
		
		$general_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => apply_filters( 'blomma_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'blomma' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'blomma' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'blomma' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'blomma' ),
				'parent'        => $general_meta_box
			)
		);
		
		$qodef_content_padding_group = blomma_select_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Styles', 'blomma' ),
				'description' => esc_html__( 'Define styles for Content area', 'blomma' ),
				'parent'      => $general_meta_box
			)
		);
		
			$qodef_content_padding_row = blomma_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row',
					'parent' => $qodef_content_padding_group
				)
			);
			
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_meta',
						'type'        => 'colorsimple',
						'label'       => esc_html__( 'Page Background Color', 'blomma' ),
						'parent'      => $qodef_content_padding_row
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_page_background_image_meta',
						'type'          => 'imagesimple',
						'label'         => esc_html__( 'Page Background Image', 'blomma' ),
						'parent'        => $qodef_content_padding_row
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_page_background_repeat_meta',
						'type'          => 'selectsimple',
						'default_value' => '',
						'label'         => esc_html__( 'Page Background Image Repeat', 'blomma' ),
						'options'       => blomma_select_get_yes_no_select_array(),
						'parent'        => $qodef_content_padding_row
					)
				);
		
			$qodef_content_padding_row_1 = blomma_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row_1',
					'next'   => true,
					'parent' => $qodef_content_padding_group
				)
			);
		
				blomma_select_create_meta_box_field(
					array(
						'name'   => 'qodef_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (eg. 10px 5px 10px 5px)', 'blomma' ),
						'parent' => $qodef_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'    => 'qodef_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (eg. 10px 5px 10px 5px)', 'blomma' ),
						'parent'  => $qodef_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'blomma' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'blomma' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'blomma' ),
					'qodef-grid-1300' => esc_html__( '1300px', 'blomma' ),
					'qodef-grid-1200' => esc_html__( '1200px', 'blomma' ),
					'qodef-grid-1100' => esc_html__( '1100px', 'blomma' ),
					'qodef-grid-1000' => esc_html__( '1000px', 'blomma' ),
					'qodef-grid-800'  => esc_html__( '800px', 'blomma' )
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_grid_space_meta',
				'type'        => 'select',
				'default_value' => '',
				'label'       => esc_html__( 'Grid Layout Space', 'blomma' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for your page', 'blomma' ),
				'options'     => blomma_select_get_space_between_items_array( true ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_global_social_share_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Integrate Social Share Button', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will display a \'share\' button for easy social sharing. The button will be fixed on the right side of the page', 'blomma' ),
				'parent'        => $general_meta_box,
				'options'       => blomma_select_get_yes_no_select_array( true )
			)
		);
		
		/***************** Boxed Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'    => 'qodef_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'blomma' ),
				'parent'  => $general_meta_box,
				'options' => blomma_select_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = blomma_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_boxed_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'blomma' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'blomma' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'blomma' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'blomma' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'blomma' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'blomma' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'blomma' ),
						'description'   => esc_html__( 'Choose background image attachment', 'blomma' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'blomma' ),
							'fixed'  => esc_html__( 'Fixed', 'blomma' ),
							'scroll' => esc_html__( 'Scroll', 'blomma' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'blomma' ),
				'parent'        => $general_meta_box,
				'options'       => blomma_select_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = blomma_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'qodef_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'blomma' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'blomma' ),
						'parent'      => $paspartu_container_meta
					)
				);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_paspartu_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Passepartout Background Image', 'blomma' ),
				'description' => esc_html__( 'Choose passepartout image', 'blomma' ),
				'parent'      => $paspartu_container_meta
			)
		);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'blomma' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'blomma' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'blomma' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'blomma' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'blomma' ),
						'options'       => blomma_select_get_yes_no_select_array(),
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'blomma' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'blomma' ),
						'options'       => blomma_select_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'blomma' ),
				'parent'        => $general_meta_box,
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = blomma_select_add_admin_container(
				array(
					'parent'     => $general_meta_box,
					'name'       => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_smooth_page_transitions_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'blomma' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'blomma' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => blomma_select_get_yes_no_select_array()
					)
				);
		
				$page_transition_preloader_container_meta = blomma_select_add_admin_container(
					array(
						'parent'     => $page_transitions_container_meta,
						'name'       => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'qodef_page_transition_preloader_meta' => array( '', 'no' )
							)
						)
					)
				);
				
					blomma_select_create_meta_box_field(
						array(
							'name'   => 'qodef_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'blomma' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = blomma_select_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'blomma' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'blomma' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = blomma_select_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					blomma_select_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'qodef_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'blomma' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'blomma' ),
								'svg_morph'             => esc_html__( 'SVG Morph', 'blomma' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'blomma' ),
								'pulse'                 => esc_html__( 'Pulse', 'blomma' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'blomma' ),
								'cube'                  => esc_html__( 'Cube', 'blomma' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'blomma' ),
								'stripes'               => esc_html__( 'Stripes', 'blomma' ),
								'wave'                  => esc_html__( 'Wave', 'blomma' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'blomma' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'blomma' ),
								'atom'                  => esc_html__( 'Atom', 'blomma' ),
								'clock'                 => esc_html__( 'Clock', 'blomma' ),
								'mitosis'               => esc_html__( 'Mitosis', 'blomma' ),
								'lines'                 => esc_html__( 'Lines', 'blomma' ),
								'fussion'               => esc_html__( 'Fussion', 'blomma' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'blomma' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'blomma' )
							)
						)
					);
					
					blomma_select_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'qodef_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'blomma' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);

					
					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_svg_path_d1_meta',
					        'default_value' => esc_html__('', 'blomma'),
					        'label'         => esc_html__('First SVG Path d attribute', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);

					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_svg_path_d2_meta',
					        'default_value' => esc_html__('', 'blomma'),
					        'label'         => esc_html__('Second SVG Path d attribute', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);

					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_svg_path_d3_meta',
					        'default_value' => esc_html__('', 'blomma'),
					        'label'         => esc_html__('Third SVG Path d attribute', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);

					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_svg_path_d4_meta',
					        'default_value' => esc_html__('', 'blomma'),
					        'label'         => esc_html__('Fourth SVG Path d attribute', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);

					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_svg_path_d5_meta',
					        'default_value' => esc_html__('', 'blomma'),
					        'label'         => esc_html__('Fifth SVG Path d attribute', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);

					blomma_select_create_meta_box_field(
					    array(
					        'type'          => 'textsimple',
					        'name'          => 'qodef_loading_message_meta',
					        'default_value' => esc_html__('Loading', 'blomma'),
					        'label'         => esc_html__('Loading Message', 'blomma'),
					        'parent'        => $row_pt_spinner_animation_meta,
					        'dependency' => array(
					        	'show' => array(
					        		'qodef_smooth_pt_spinner_type_meta' => 'svg_morph'
				        		)
				        	)
					    )
					);
					
					blomma_select_create_meta_box_field(
						array(
							'name'        => 'qodef_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'blomma' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'blomma' ),
							'options'     => blomma_select_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'blomma' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'blomma' ),
				'parent'      => $general_meta_box,
				'options'     => blomma_select_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_general_meta', 10 );
}

if ( ! function_exists( 'blomma_select_container_background_style' ) ) {
	/**
	 * Function that return container style
	 */
	function blomma_select_container_background_style( $style ) {
		$page_id      = blomma_select_get_page_id();
		$class_prefix = blomma_select_get_unique_page_class( $page_id, true );
		
		$container_selector = array(
			$class_prefix . ' .qodef-content'
		);
		
		$container_class        = array();
		$page_background_color  = get_post_meta( $page_id, 'qodef_page_background_color_meta', true );
		$page_background_image  = get_post_meta( $page_id, 'qodef_page_background_image_meta', true );
		$page_background_repeat = get_post_meta( $page_id, 'qodef_page_background_repeat_meta', true );
		
		if ( ! empty( $page_background_color ) ) {
			$container_class['background-color'] = $page_background_color;
		}
		
		if ( ! empty( $page_background_image ) ) {
			$container_class['background-image'] = 'url(' . esc_url( $page_background_image ) . ')';
			
			if ( $page_background_repeat === 'yes' ) {
				$container_class['background-repeat']   = 'repeat';
				$container_class['background-position'] = '0 0';
			} else {
				$container_class['background-repeat']   = 'no-repeat';
				$container_class['background-position'] = 'center 0';
				$container_class['background-size']     = 'cover';
			}
		}
		
		$current_style = blomma_select_dynamic_css( $container_selector, $container_class );
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'blomma_select_filter_add_page_custom_style', 'blomma_select_container_background_style' );
}