<?php

if ( ! function_exists( 'blomma_select_social_options_map' ) ) {
	function blomma_select_social_options_map() {

	    $page = '_social_page';
		
		blomma_select_add_admin_page(
			array(
				'slug'  => '_social_page',
				'title' => esc_html__( 'Social Networks', 'blomma' ),
				'icon'  => 'fa fa-share-alt'
			)
		);
		
		/**
		 * Enable Social Share
		 */
		$panel_social_share = blomma_select_add_admin_panel(
			array(
				'page'  => '_social_page',
				'name'  => 'panel_social_share',
				'title' => esc_html__( 'Enable Social Share', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_social_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Social Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow social share on networks of your choice', 'blomma' ),
				'parent'        => $panel_social_share
			)
		);
		
		$panel_show_social_share_on = blomma_select_add_admin_panel(
			array(
				'page'            => '_social_page',
				'name'            => 'panel_show_social_share_on',
				'title'           => esc_html__( 'Show Social Share On', 'blomma' ),
				'dependency' => array(
					'show' => array(
						'enable_social_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_social_share_on_post',
				'default_value' => 'no',
				'label'         => esc_html__( 'Posts', 'blomma' ),
				'description'   => esc_html__( 'Show Social Share on Blog Posts', 'blomma' ),
				'parent'        => $panel_show_social_share_on
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_social_share_on_page',
				'default_value' => 'no',
				'label'         => esc_html__( 'Pages', 'blomma' ),
				'description'   => esc_html__( 'Show Social Share on Pages', 'blomma' ),
				'parent'        => $panel_show_social_share_on
			)
		);

        /**
         * Action for embedding social share option for custom post types
         */
		do_action('blomma_select_action_post_types_social_share', $panel_show_social_share_on);
		
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'global_social_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Integrate Social Share Button', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will display a \'share\' button for easy social sharing. The button will be fixed on the right side of the page', 'blomma' ),
				'parent'        => $panel_show_social_share_on
			)
		);
		
		/**
		 * Social Share Networks
		 */
		$panel_social_networks = blomma_select_add_admin_panel(
			array(
				'page'            => '_social_page',
				'name'            => 'panel_social_networks',
				'title'           => esc_html__( 'Social Networks', 'blomma' ),
				'dependency' => array(
					'hide' => array(
						'enable_social_share'  => 'no'
					)
				)
			)
		);
		
		/**
		 * Facebook
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'facebook_title',
				'title'  => esc_html__( 'Share on Facebook', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_facebook_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via Facebook', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_facebook_share_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_facebook_share_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_facebook_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'facebook_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_facebook_share_container
			)
		);
		
		/**
		 * Twitter
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'twitter_title',
				'title'  => esc_html__( 'Share on Twitter', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_twitter_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via Twitter', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_twitter_share_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_twitter_share_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_twitter_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'twitter_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_twitter_share_container
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'text',
				'name'          => 'twitter_via',
				'default_value' => '',
				'label'         => esc_html__( 'Via', 'blomma' ),
				'parent'        => $enable_twitter_share_container
			)
		);
		
		/**
		 * Linked In
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'linkedin_title',
				'title'  => esc_html__( 'Share on LinkedIn', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_linkedin_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via LinkedIn', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_linkedin_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_linkedin_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_linkedin_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'linkedin_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_linkedin_container
			)
		);
		
		/**
		 * Tumblr
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'tumblr_title',
				'title'  => esc_html__( 'Share on Tumblr', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_tumblr_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via Tumblr', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_tumblr_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_tumblr_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_tumblr_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'tumblr_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_tumblr_container
			)
		);
		
		/**
		 * Pinterest
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'pinterest_title',
				'title'  => esc_html__( 'Share on Pinterest', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_pinterest_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via Pinterest', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_pinterest_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_pinterest_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_pinterest_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'pinterest_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_pinterest_container
			)
		);
		
		/**
		 * VK
		 */
		blomma_select_add_admin_section_title(
			array(
				'parent' => $panel_social_networks,
				'name'   => 'vk_title',
				'title'  => esc_html__( 'Share on VK', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_vk_share',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Share', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow sharing via VK', 'blomma' ),
				'parent'        => $panel_social_networks
			)
		);
		
		$enable_vk_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_vk_container',
				'parent'          => $panel_social_networks,
				'dependency' => array(
					'show' => array(
						'enable_vk_share'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'vk_icon',
				'default_value' => '',
				'label'         => esc_html__( 'Upload Icon', 'blomma' ),
				'parent'        => $enable_vk_container
			)
		);
		
		if ( defined( 'BLOMMA_TWITTER_FEED_VERSION' ) ) {
			$twitter_panel = blomma_select_add_admin_panel(
				array(
					'title' => esc_html__( 'Twitter', 'blomma' ),
					'name'  => 'panel_twitter',
					'page'  => '_social_page'
				)
			);
			
			blomma_select_add_admin_twitter_button(
				array(
					'name'   => 'twitter_button',
					'parent' => $twitter_panel
				)
			);
		}
		
		if ( defined( 'BLOMMA_INSTAGRAM_FEED_VERSION' ) ) {
			$instagram_panel = blomma_select_add_admin_panel(
				array(
					'title' => esc_html__( 'Instagram', 'blomma' ),
					'name'  => 'panel_instagram',
					'page'  => '_social_page'
				)
			);
			
			blomma_select_add_admin_instagram_button(
				array(
					'name'   => 'instagram_button',
					'parent' => $instagram_panel
				)
			);
		}
		
		/**
		 * Open Graph
		 */
		$panel_open_graph = blomma_select_add_admin_panel(
			array(
				'page'  => '_social_page',
				'name'  => 'panel_open_graph',
				'title' => esc_html__( 'Open Graph', 'blomma' ),
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'enable_open_graph',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Open Graph', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will allow usage of Open Graph protocol on your site', 'blomma' ),
				'parent'        => $panel_open_graph
			)
		);
		
		$enable_open_graph_container = blomma_select_add_admin_container(
			array(
				'name'            => 'enable_open_graph_container',
				'parent'          => $panel_open_graph,
				'dependency' => array(
					'show' => array(
						'enable_open_graph'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'image',
				'name'          => 'open_graph_image',
				'default_value' => SELECT_ASSETS_ROOT . '/img/open_graph.jpg',
				'label'         => esc_html__( 'Default Share Image', 'blomma' ),
				'parent'        => $enable_open_graph_container,
				'description'   => esc_html__( 'Used when featured image is not set. Make sure that image is at least 1200 x 630 pixels, up to 8MB in size', 'blomma' ),
			)
		);

        /**
         * Action for embedding social share option for custom post types
         */
        do_action('blomma_select_action_social_options', $page);
	}
	
	add_action( 'blomma_select_action_options_map', 'blomma_select_social_options_map', blomma_select_set_options_map_position( 'social' ) );
}