<?php
$blog_single_navigation = blomma_select_options()->getOptionValue('blog_single_navigation') === 'no' ? false : true;
$blog_navigation_through_same_category = blomma_select_options()->getOptionValue('blog_navigation_through_same_category') === 'no' ? false : true;
?>
<?php if($blog_single_navigation){ ?>
	<div class="qodef-blog-single-navigation">
		<div class="qodef-blog-single-navigation-inner clearfix">
			<?php
				/* Single navigation section - SETTING PARAMS */
				$post_navigation = array(
					'prev' => array(
						'mark' => '<span class="qodef-blog-single-nav-mark"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="72px" height="14px" viewBox="0 0 72 14" enable-background="new 0 0 72 14" xml:space="preserve"><g><defs><rect id="SVGID_1_" width="72" height="14"/></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_"  overflow="visible"/></clipPath><line clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-width="0.991" stroke-miterlimit="10" x1="71" y1="7" x2="1" y2="7"/><polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-miterlimit="10" points="7.364,0.636 1,7 7.364,13.364"/></g></svg></span>',
						'label' => '<span class="qodef-blog-single-nav-label">'.esc_html__('previous', 'blomma').'</span>'
					),
					'next' => array(
						'mark' => '<span class="qodef-blog-single-nav-mark"><svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="72px" height="14px" viewBox="0 0 72 14" enable-background="new 0 0 72 14" xml:space="preserve"><g><defs><rect id="SVGID_1_" width="72" height="14"/></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_" overflow="visible"/></clipPath><line clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-width="0.991" stroke-miterlimit="10" x1="1" y1="7" x2="71" y2="7"/><polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-miterlimit="10" points="64.636,0.636 71,7 	64.636,13.364"/></g></svg></span>',
						'label' => '<span class="qodef-blog-single-nav-label">'.esc_html__('next', 'blomma').'</span>'
					)
				);
			
				if($blog_navigation_through_same_category){
					if(get_previous_post(true) !== ""){
						$post_navigation['prev']['post'] = get_previous_post(true);
					}
					if(get_next_post(true) !== ""){
						$post_navigation['next']['post'] = get_next_post(true);
					}
				} else {
					if(get_previous_post() !== ""){
						$post_navigation['prev']['post'] = get_previous_post();
					}
					if(get_next_post() !== ""){
						$post_navigation['next']['post'] = get_next_post();
					}
				}

				/* Single navigation section - RENDERING */
				foreach (array('prev', 'next') as $nav_type) {
					if (isset($post_navigation[$nav_type]['post'])) { ?>
						<a itemprop="url" class="qodef-blog-single-<?php echo esc_attr($nav_type); ?>" href="<?php echo get_permalink($post_navigation[$nav_type]['post']->ID); ?>">
                            <?php echo wp_kses($post_navigation[$nav_type]['mark'], array('span' => array('class' => true))); ?>
                            <?php echo wp_kses($post_navigation[$nav_type]['label'], array('span' => array('class' => true))); ?>
						</a>
					<?php }
				}
			?>
		</div>
	</div>
<?php } ?>