<?php

if ( ! function_exists( 'blomma_select_footer_options_map' ) ) {
	function blomma_select_footer_options_map() {

		blomma_select_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'blomma' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = blomma_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'blomma' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'blomma' ),
				'parent'        => $footer_panel
			)
		);

        blomma_select_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'blomma' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'blomma' ),
                'parent'        => $footer_panel
            )
        );

		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'blomma' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = blomma_select_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		blomma_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '12',
				'label'         => esc_html__( 'Footer Top Columns', 'blomma' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'blomma' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		blomma_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'center',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'blomma' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'blomma' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'blomma' ),
					'left'   => esc_html__( 'Left', 'blomma' ),
					'center' => esc_html__( 'Center', 'blomma' ),
					'right'  => esc_html__( 'Right', 'blomma' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = blomma_select_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'blomma' ),
				'description' => esc_html__( 'Define style for footer top area', 'blomma' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = blomma_select_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'blomma' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'blomma' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'blomma' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'blomma' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = blomma_select_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		blomma_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'blomma' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'blomma' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = blomma_select_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'blomma' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'blomma' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = blomma_select_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'blomma' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'blomma' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			blomma_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'blomma' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'blomma_select_action_options_map', 'blomma_select_footer_options_map', blomma_select_set_options_map_position( 'footer' ) );
}