<?php

if ( ! function_exists( 'blomma_select_map_sidebar_meta' ) ) {
	function blomma_select_map_sidebar_meta() {
		$qodef_sidebar_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => apply_filters( 'blomma_select_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'blomma' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'blomma' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'blomma' ),
				'parent'      => $qodef_sidebar_meta_box,
                'options'       => blomma_select_get_custom_sidebars_options( true )
			)
		);
		
		$qodef_custom_sidebars = blomma_select_get_custom_sidebars();
		if ( count( $qodef_custom_sidebars ) > 0 ) {
			blomma_select_create_meta_box_field(
				array(
					'name'        => 'qodef_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'blomma' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'blomma' ),
					'parent'      => $qodef_sidebar_meta_box,
					'options'     => $qodef_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_sidebar_meta', 31 );
}