<?php

if ( ! function_exists( 'blomma_core_map_portfolio_meta' ) ) {
	function blomma_core_map_portfolio_meta() {
		global $blomma_select_global_Framework;
		
		$blomma_pages = array();
		$pages      = get_pages();
		foreach ( $pages as $page ) {
			$blomma_pages[ $page->ID ] = $page->post_title;
		}
		
		//Portfolio Images
		
		$blomma_portfolio_images = new BlommaSelectClassMetaBox( 'portfolio-item', esc_html__( 'Portfolio Images (multiple upload)', 'blomma-core' ), '', '', 'portfolio_images' );
		$blomma_select_global_Framework->qodeMetaBoxes->addMetaBox( 'portfolio_images', $blomma_portfolio_images );
		
		$blomma_portfolio_image_gallery = new BlommaSelectClassMultipleImages( 'qodef-portfolio-image-gallery', esc_html__( 'Portfolio Images', 'blomma-core' ), esc_html__( 'Choose your portfolio images', 'blomma-core' ) );
		$blomma_portfolio_images->addChild( 'qodef-portfolio-image-gallery', $blomma_portfolio_image_gallery );
		
		//Portfolio Single Upload Images/Videos 
		
		$blomma_portfolio_images_videos = blomma_select_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Portfolio Images/Videos (single upload)', 'blomma-core' ),
				'name'  => 'qodef_portfolio_images_videos'
			)
		);
		blomma_select_add_repeater_field(
			array(
				'name'        => 'qodef_portfolio_single_upload',
				'parent'      => $blomma_portfolio_images_videos,
				'button_text' => esc_html__( 'Add Image/Video', 'blomma-core' ),
				'fields'      => array(
					array(
						'type'        => 'select',
						'name'        => 'file_type',
						'label'       => esc_html__( 'File Type', 'blomma-core' ),
						'options' => array(
							'image' => esc_html__('Image','blomma-core'),
							'video' => esc_html__('Video','blomma-core'),
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'single_image',
						'label'       => esc_html__( 'Image', 'blomma-core' ),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'image'
							)
						)
					),
					array(
						'type'        => 'select',
						'name'        => 'video_type',
						'label'       => esc_html__( 'Video Type', 'blomma-core' ),
						'options'	  => array(
							'youtube' => esc_html__('YouTube', 'blomma-core'),
							'vimeo' => esc_html__('Vimeo', 'blomma-core'),
							'self' => esc_html__('Self Hosted', 'blomma-core'),
						),
						'dependency' => array(
							'show' => array(
								'file_type'  => 'video'
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_id',
						'label'       => esc_html__( 'Video ID', 'blomma-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => array('youtube','vimeo')
							)
						)
					),
					array(
						'type'        => 'text',
						'name'        => 'video_mp4',
						'label'       => esc_html__( 'Video mp4', 'blomma-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					),
					array(
						'type'        => 'image',
						'name'        => 'video_cover_image',
						'label'       => esc_html__( 'Video Cover Image', 'blomma-core' ),
						'dependency' => array(
							'show' => array(
								'file_type' => 'video',
								'video_type'  => 'self'
							)
						)
					)
				)
			)
		);
		
		//Portfolio Additional Sidebar Items
		
		$blomma_additional_sidebar_items = blomma_select_create_meta_box(
			array(
				'scope' => array( 'portfolio-item' ),
				'title' => esc_html__( 'Additional Portfolio Sidebar Items', 'blomma-core' ),
				'name'  => 'portfolio_properties'
			)
		);

		blomma_select_add_repeater_field(
			array(
				'name'        => 'qodef_portfolio_properties',
				'parent'      => $blomma_additional_sidebar_items,
				'button_text' => esc_html__( 'Add New Item', 'blomma-core' ),
				'fields'      => array(
					array(
						'type'        => 'text',
						'name'        => 'item_title',
						'label'       => esc_html__( 'Item Title', 'blomma-core' ),
					),
					array(
						'type'        => 'text',
						'name'        => 'item_text',
						'label'       => esc_html__( 'Item Text', 'blomma-core' )
					),
					array(
						'type'        => 'text',
						'name'        => 'item_url',
						'label'       => esc_html__( 'Enter Full URL for Item Text Link', 'blomma-core' )
					)
				)
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_core_map_portfolio_meta', 40 );
}