<?php

if ( ! function_exists( 'blomma_select_reset_options_map' ) ) {
	/**
	 * Reset options panel
	 */
	function blomma_select_reset_options_map() {
		
		blomma_select_add_admin_page(
			array(
				'slug'  => '_reset_page',
				'title' => esc_html__( 'Reset', 'blomma' ),
				'icon'  => 'fa fa-retweet'
			)
		);
		
		$panel_reset = blomma_select_add_admin_panel(
			array(
				'page'  => '_reset_page',
				'name'  => 'panel_reset',
				'title' => esc_html__( 'Reset', 'blomma' )
			)
		);
		
		blomma_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'reset_to_defaults',
				'default_value' => 'no',
				'label'         => esc_html__( 'Reset to Defaults', 'blomma' ),
				'description'   => esc_html__( 'This option will reset all Select Options values to defaults', 'blomma' ),
				'parent'        => $panel_reset
			)
		);
	}
	
	add_action( 'blomma_select_action_options_map', 'blomma_select_reset_options_map', blomma_select_set_options_map_position( 'reset' ) );
}