<?php

if ( ! function_exists( 'blomma_select_map_post_audio_meta' ) ) {
	function blomma_select_map_post_audio_meta() {
		$audio_post_format_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'blomma' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'blomma' ),
				'description'   => esc_html__( 'Choose audio type', 'blomma' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'blomma' ),
					'self'            => esc_html__( 'Self Hosted', 'blomma' )
				)
			)
		);
		
		$qodef_audio_embedded_container = blomma_select_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'qodef_audio_embedded_container'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'blomma' ),
				'description' => esc_html__( 'Enter audio URL', 'blomma' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'blomma' ),
				'description' => esc_html__( 'Enter audio link', 'blomma' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_post_audio_meta', 23 );
}