<?php

if ( ! function_exists( 'blomma_select_get_hide_dep_for_header_menu_area_meta_boxes' ) ) {
	function blomma_select_get_hide_dep_for_header_menu_area_meta_boxes() {
		$hide_dep_options = apply_filters( 'blomma_select_filter_header_menu_area_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'blomma_select_header_menu_area_meta_options_map' ) ) {
	function blomma_select_header_menu_area_meta_options_map( $header_meta_box ) {
		$hide_dep_options = blomma_select_get_hide_dep_for_header_menu_area_meta_boxes();
		
		$menu_area_container = blomma_select_add_admin_container_no_style(
			array(
				'type'       => 'container',
				'name'       => 'menu_area_container',
				'parent'     => $header_meta_box,
				'dependency' => array(
					'hide' => array(
						'qodef_header_type_meta' => $hide_dep_options
					)
				),
				'args'       => array(
					'enable_panels_for_default_value' => true
				)
			)
		);
		
		blomma_select_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'blomma' )
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_menu_area_in_grid_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area In Grid', 'blomma' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'blomma' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_container = blomma_select_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'qodef_menu_area_in_grid_meta'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_grid_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Grid Background Color', 'blomma' ),
				'description' => esc_html__( 'Set grid background color for menu area', 'blomma' ),
				'parent'      => $menu_area_in_grid_container
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_grid_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Grid Background Transparency', 'blomma' ),
				'description' => esc_html__( 'Set grid background transparency for menu area (0 = fully transparent, 1 = opaque)', 'blomma' ),
				'parent'      => $menu_area_in_grid_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_menu_area_in_grid_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Shadow', 'blomma' ),
				'description'   => esc_html__( 'Set shadow on grid menu area', 'blomma' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_menu_area_in_grid_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Grid Area Border', 'blomma' ),
				'description'   => esc_html__( 'Set border on grid menu area', 'blomma' ),
				'parent'        => $menu_area_in_grid_container,
				'default_value' => '',
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		$menu_area_in_grid_border_container = blomma_select_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_in_grid_border_container',
				'parent'          => $menu_area_in_grid_container,
				'dependency' => array(
					'show' => array(
						'qodef_menu_area_in_grid_border_meta'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_in_grid_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'blomma' ),
				'description' => esc_html__( 'Set border color for grid area', 'blomma' ),
				'parent'      => $menu_area_in_grid_border_container
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_background_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Background Color', 'blomma' ),
				'description' => esc_html__( 'Choose a background color for menu area', 'blomma' ),
				'parent'      => $menu_area_container
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_background_transparency_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Transparency', 'blomma' ),
				'description' => esc_html__( 'Choose a transparency for the menu area background color (0 = fully transparent, 1 = opaque)', 'blomma' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 2
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_menu_area_shadow_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Shadow', 'blomma' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'blomma' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_menu_area_border_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Menu Area Border', 'blomma' ),
				'description'   => esc_html__( 'Set border on menu area', 'blomma' ),
				'parent'        => $menu_area_container,
				'default_value' => '',
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		$menu_area_border_bottom_color_container = blomma_select_add_admin_container(
			array(
				'type'            => 'container',
				'name'            => 'menu_area_border_bottom_color_container',
				'parent'          => $menu_area_container,
				'dependency' => array(
					'show' => array(
						'qodef_menu_area_border_meta'  => 'yes'
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_menu_area_border_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Border Color', 'blomma' ),
				'description' => esc_html__( 'Choose color of header bottom border', 'blomma' ),
				'parent'      => $menu_area_border_bottom_color_container
			)
		);

		blomma_select_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'qodef_menu_area_height_meta',
				'label'       => esc_html__( 'Height', 'blomma' ),
				'description' => esc_html__( 'Enter header height', 'blomma' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px', 'blomma' )
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'type'        => 'text',
				'name'        => 'qodef_menu_area_side_padding_meta',
				'label'       => esc_html__( 'Menu Area Side Padding', 'blomma' ),
				'description' => esc_html__( 'Enter value in px or percentage to define menu area side padding', 'blomma' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => esc_html__( 'px or %', 'blomma' )
				)
			)
		);
		
		do_action( 'blomma_select_header_menu_area_additional_meta_boxes_map', $menu_area_container );
	}
	
	add_action( 'blomma_select_action_header_menu_area_meta_boxes_map', 'blomma_select_header_menu_area_meta_options_map', 10, 1 );
}