<?php

if ( ! function_exists( 'blomma_select_sidebar_options_map' ) ) {
	function blomma_select_sidebar_options_map() {
		
		blomma_select_add_admin_page(
			array(
				'slug'  => '_sidebar_page',
				'title' => esc_html__( 'Sidebar Area', 'blomma' ),
				'icon'  => 'fa fa-indent'
			)
		);
		
		$sidebar_panel = blomma_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Sidebar Area', 'blomma' ),
				'name'  => 'sidebar',
				'page'  => '_sidebar_page'
			)
		);
		
		blomma_select_add_admin_field( array(
			'name'          => 'sidebar_layout',
			'type'          => 'select',
			'label'         => esc_html__( 'Sidebar Layout', 'blomma' ),
			'description'   => esc_html__( 'Choose a sidebar layout for pages', 'blomma' ),
			'parent'        => $sidebar_panel,
			'default_value' => 'no-sidebar',
            'options'       => blomma_select_get_custom_sidebars_options()
		) );
		
		$blomma_custom_sidebars = blomma_select_get_custom_sidebars();
		if ( count( $blomma_custom_sidebars ) > 0 ) {
			blomma_select_add_admin_field( array(
				'name'        => 'custom_sidebar_area',
				'type'        => 'selectblank',
				'label'       => esc_html__( 'Sidebar to Display', 'blomma' ),
				'description' => esc_html__( 'Choose a sidebar to display on pages. Default sidebar is "Sidebar"', 'blomma' ),
				'parent'      => $sidebar_panel,
				'options'     => $blomma_custom_sidebars,
				'args'        => array(
					'select2' => true
				)
			) );
		}
	}
	
	add_action( 'blomma_select_action_options_map', 'blomma_select_sidebar_options_map', blomma_select_set_options_map_position( 'sidebar' ) );
}