<?php

if ( ! function_exists( 'blomma_select_get_title_types_meta_boxes' ) ) {
	function blomma_select_get_title_types_meta_boxes() {
		$title_type_options = apply_filters( 'blomma_select_filter_title_type_meta_boxes', $title_type_options = array( '' => esc_html__( 'Default', 'blomma' ) ) );
		
		return $title_type_options;
	}
}

foreach ( glob( SELECT_FRAMEWORK_MODULES_ROOT_DIR . '/title/types/*/admin/meta-boxes/*.php' ) as $meta_box_load ) {
	include_once $meta_box_load;
}

if ( ! function_exists( 'blomma_select_map_title_meta' ) ) {
	function blomma_select_map_title_meta() {
		$title_type_meta_boxes = blomma_select_get_title_types_meta_boxes();
		
		$title_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => apply_filters( 'blomma_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'title_meta' ),
				'title' => esc_html__( 'Title', 'blomma' ),
				'name'  => 'title_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'blomma' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'blomma' ),
				'parent'        => $title_meta_box,
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
			$show_title_area_meta_container = blomma_select_add_admin_container(
				array(
					'parent'          => $title_meta_box,
					'name'            => 'qodef_show_title_area_meta_container',
					'dependency' => array(
						'hide' => array(
							'qodef_show_title_area_meta' => 'no'
						)
					)
				)
			);
		
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_type_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area Type', 'blomma' ),
						'description'   => esc_html__( 'Choose title type', 'blomma' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => $title_type_meta_boxes
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_in_grid_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Area In Grid', 'blomma' ),
						'description'   => esc_html__( 'Set title area content to be in grid', 'blomma' ),
						'options'       => blomma_select_get_yes_no_select_array(),
						'parent'        => $show_title_area_meta_container
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_height_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Height', 'blomma' ),
						'description' => esc_html__( 'Set a height for Title Area', 'blomma' ),
						'parent'      => $show_title_area_meta_container,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px'
						)
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Background Color', 'blomma' ),
						'description' => esc_html__( 'Choose a background color for title area', 'blomma' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_area_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'blomma' ),
						'description' => esc_html__( 'Choose an Image for title area', 'blomma' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_background_image_behavior_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Behavior', 'blomma' ),
						'description'   => esc_html__( 'Choose title area background image behavior', 'blomma' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''                    => esc_html__( 'Default', 'blomma' ),
							'hide'                => esc_html__( 'Hide Image', 'blomma' ),
							'responsive'          => esc_html__( 'Enable Responsive Image', 'blomma' ),
							'responsive-disabled' => esc_html__( 'Disable Responsive Image', 'blomma' ),
							'parallax'            => esc_html__( 'Enable Parallax Image', 'blomma' ),
							'parallax-zoom-out'   => esc_html__( 'Enable Parallax With Zoom Out Image', 'blomma' ),
							'parallax-disabled'   => esc_html__( 'Disable Parallax Image', 'blomma' )
						)
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_vertical_alignment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Vertical Alignment', 'blomma' ),
						'description'   => esc_html__( 'Specify title area content vertical alignment', 'blomma' ),
						'parent'        => $show_title_area_meta_container,
						'options'       => array(
							''              => esc_html__( 'Default', 'blomma' ),
							'header-bottom' => esc_html__( 'From Bottom of Header', 'blomma' ),
							'window-top'    => esc_html__( 'From Window Top', 'blomma' )
						)
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_title_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Title Tag', 'blomma' ),
						'options'       => blomma_select_get_title_tag( true ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_title_text_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Title Color', 'blomma' ),
						'description' => esc_html__( 'Choose a color for title text', 'blomma' ),
						'parent'      => $show_title_area_meta_container
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_meta',
						'type'          => 'text',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Text', 'blomma' ),
						'description'   => esc_html__( 'Enter your subtitle text', 'blomma' ),
						'parent'        => $show_title_area_meta_container,
						'args'          => array(
							'col_width' => 6
						)
					)
				);
		
				blomma_select_create_meta_box_field(
					array(
						'name'          => 'qodef_title_area_subtitle_tag_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Subtitle Tag', 'blomma' ),
						'options'       => blomma_select_get_title_tag( true, array( 'p' => 'p' ) ),
						'parent'        => $show_title_area_meta_container
					)
				);
				
				blomma_select_create_meta_box_field(
					array(
						'name'        => 'qodef_subtitle_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Subtitle Color', 'blomma' ),
						'description' => esc_html__( 'Choose a color for subtitle text', 'blomma' ),
						'parent'      => $show_title_area_meta_container
					)
				);
		
		/***************** Additional Title Area Layout - start *****************/
		
		do_action( 'blomma_select_action_additional_title_area_meta_boxes', $show_title_area_meta_container );
		
		/***************** Additional Title Area Layout - end *****************/
		
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_title_meta', 60 );
}