(function($) {
    'use strict';

    var portfolioFullScreenSlider = {};
    qodef.modules.qodefInitPortfolioFullScreenSlider = qodefInitPortfolioFullScreenSlider;

    portfolioFullScreenSlider.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);
    
    /* 
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
	    qodefInitPortfolioFullScreenSlider();
    }


    /**
     * Initializes portfolio full screen slider logic
     */
    function qodefInitPortfolioFullScreenSlider(){
        var holders = $('.qodef-portfolio-full-screen-slider-holder');

        if(holders.length){
	        holders.each(function(){
                var holder = $(this),
                	infoBlock = $('#qodef-ptf-info-block'),
                	infoHolder = infoBlock.find('.qodef-pli-info-holder'),
                	titleArea = infoBlock.find('.qodef-pli-title'),
                	dateArea = infoBlock.find('.qodef-pli-date'),
                	excerptInfoArea = infoBlock.find('.qodef-pli-excerpt'),
                	categoryInfoArea = infoBlock.find('.qodef-pli-category-info > p'),
                	dateInfoArea = infoBlock.find('.qodef-pli-date-info > p'),
                	tagInfoArea = infoBlock.find('.qodef-pli-tag-info > p'),
                	shareListInfoArea = infoBlock.find('.qodef-social-share-holder > ul'),
                	infoOpener = infoBlock.find('.qodef-pli-up-arrow'),
                	mousewheelScroll = holder.find('.qodef-portfolio-list-holder').data('enable-mousewheel-scroll') == 'yes' ? true : false,
	                swiperInstance = holder.find('.swiper-container'),
            		swiperSlider = new Swiper (swiperInstance, {
            			loop: true,
            			direction: 'vertical',
            			slidesPerView: 1,
            			speed: 1000,
            			mousewheel: mousewheelScroll,
            			autoplay: {
            			    delay: 2800,
            			},
            			navigation: {
            			  nextEl: '.qodef-next-icon',
            			  prevEl: '.qodef-prev-icon',
            			},
            			init: false
		    		});

            	var setInfo = function() {
            		var activeSlide = swiperInstance.find('.swiper-slide-active'),
            			titleHtml = activeSlide.find('.qodef-pli-title').html(),
            			dateVal = activeSlide.find('.qodef-pli-date').text(),
            			excerptVal = activeSlide.find('.qodef-pli-excerpt').text(),
            			categoryHtml = activeSlide.find('.qodef-pli-category-info > p').html(),
            			tagHtml = activeSlide.find('.qodef-pli-tag-info > p').html(),
            			shareListHtml = activeSlide.find('.qodef-social-share-holder > ul').html();

            		titleArea.html(titleHtml);
            		dateArea.text(dateVal);
            		excerptInfoArea.text(excerptVal);
            		categoryInfoArea.html(categoryHtml);
            		dateInfoArea.text(dateVal);
            		tagInfoArea.html(tagHtml);
            		shareListInfoArea.html(shareListHtml);
            	}

            	var infoToggle = function() {
            		infoOpener.on('click', function(){
            			qodef.body.toggleClass('qodef-pfss-item-is-active');
        				infoBlock.toggleClass('qodef-active');
        				infoOpener.toggleClass('qodef-active');
        				dateArea.toggleClass('qodef-hide');
        				infoHolder.toggleClass('qodef-show');

        				if (qodef.body.hasClass('qodef-pfss-item-is-active')) {
        					swiperSlider.autoplay.stop();
        				} else {
        					swiperSlider.autoplay.start();
        					swiperSlider.slideNext();
        				}
            		});
            	}

		        var fullscreenCalcs = function() {
		        	var topOffset = holder.offset().top,
                    	passepartoutHeight = qodef.body.hasClass('qodef-paspartu-enabled') ? parseInt( $('.qodef-wrapper').css('padding-top'), 10 ) : 0;

			        holder.css('height', qodef.windowHeight - topOffset - passepartoutHeight);
		        }


            	swiperSlider.on('init', function(){
            		holder.addClass('qodef-initialized');
			    });

            	swiperSlider.on('slideChangeTransitionStart', function(){
		        	setInfo();
			    });

		        holder.waitForImages(function(){
		        	fullscreenCalcs();
                	swiperSlider.init();
		        	infoToggle();
		        });

		        $(window).resize(function(){
		        	fullscreenCalcs();
		        });
		
		        // items.each(function(){
			       //  var item = $(this),
			       //      arrow = item.find('.qodef-pli-up-arrow');
			
			       //  arrow.on('click', function (e) {
				      //   e.preventDefault();
				
				      //   if (arrow.hasClass('qodef-active')) {
					     //    qodef.body.removeClass('qodef-pfss-item-is-active');
					     //    arrow.removeClass('qodef-active');
					     //    item.removeClass('qodef-pfss-active');
				      //   } else {
					     //    qodef.body.addClass('qodef-pfss-item-is-active');
					     //    arrow.addClass('qodef-active');
					     //    item.addClass('qodef-pfss-active');
				      //   }
			       //  });
		        // });
		
		        // $(document).on('owl_onchanged_slider_trigger', function(){
			       //  qodef.body.removeClass('qodef-pfss-item-is-active');
			       //  items.find('.qodef-pli-up-arrow').removeClass('qodef-active');
			       //  items.removeClass('qodef-pfss-active');
		        // });
            });
        }
    }

})(jQuery);