(function($) {
    'use strict';

    var portfolioFullScreenSlider = {};
    //qodef.modules.portfolio = portfolio;

    portfolioFullScreenSlider.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);
    
    /* 
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
	    qodefPortfolioFullscreenSlider();
	    qodefInitPortfolioFeaturedScroll();
    }
	
	
	function qodefPortfolioFullscreenSlider(){
		var fullscreenSliders = $('.qodef-portfolio-fullscreen-projects-holder');
		
		if (fullscreenSliders.length){
			fullscreenSliders.each(function () {
				var thisSlider = $(this),
					articles = thisSlider.find('.qodef-pfs-item'),
					articlesLink = thisSlider.find('.qodef-pfs-link'),
					articlesImages = thisSlider.find('.qodef-pfs-image-holder .qodef-pfs-image-holder-item'),
					articlesHolder = thisSlider.find('.qodef-pfs-articles-holder'),
					swiperInstance = thisSlider.find('.swiper-container'),
					direction = 'vertical',
					loop = false,
					wheel = true,
					slideSpeed = 600,
					slidesOffsetBefore = 0,
					mobileHeaderHeight = $('.qodef-mobile-header').height();
				
				articles.eq(0).addClass('hovered');
				articlesImages.eq(0).addClass('hovered');
				
				//remove first click when on touch devices - go to link on second click
				if(qodef.htmlEl.hasClass('touch')){
					articlesLink.eq(0).addClass('active');
					
					articlesLink.each(function () {
						var link = $(this);
						
						link.on('click', function(e){
							if (!link.hasClass('active')) {
								e.preventDefault();
								articlesLink.removeClass('active');
								link.addClass('active');
							}
						});
					});
				}
				
				articles.each(function(e){
					var thisArticle = $(this);
					
					thisArticle.on('mouseover', function () {
						var imageHolder = articlesImages.eq(e);
						
						if (!thisArticle.hasClass('hovered')){
							thisArticle.siblings().removeClass('hovered');
							imageHolder.siblings().removeClass('hovered');
							
							thisArticle.addClass('hovered');
							imageHolder.addClass('hovered');
						}
					});
				});
				
				if(qodef.htmlEl.hasClass('touch')){
					thisSlider.css('height','calc(100vh - '+mobileHeaderHeight+'px)');
				}
				
				slidesOffsetBefore = -qodef.windowHeight * 0.3;
				
				if(qodef.windowWidth <= 1300) {
					slidesOffsetBefore = -qodef.windowHeight * 0.6;
				}
				
				if(qodef.windowWidth <= 1025) {
					slidesOffsetBefore = -qodef.windowHeight * 0.3;
				}
				
				if (qodef.htmlEl.hasClass('touch')) {
					
					articles.each(function(){
						$(this).css('min-height', $(this).outerHeight());
					})
				}

				
				//sliders
				var swiperSlider = new Swiper(swiperInstance, {
					loop: loop,
					initialSlide: 0,
					slidesOffsetBefore: slidesOffsetBefore,
					slidesPerView: 'auto',
					centeredSlides: true,
					speed: slideSpeed,
					direction: direction,
					mousewheelControl: wheel,
					preventClicks: true,
					preventClicksPropagation: false,
					on: {
						init: function () {
							thisSlider.addClass('qodef-initialized');
						},
						slideNextTransitionEnd: function(slider) {
							
							// var lastSlide = articlesHolder.find('.qodef-pfs-item').last();
							 //if (lastSlide.offset().top + lastSlide.height() <= qodef.windowHeight) {
							 //slider.lockSwipeToNext();
							 //} else {
							 //slider.unlockSwipeToNext();
							 //}
						}
					}
				});
				
				
			});
		}
	}
	
	/*adds scrolling to portfolio titles on the left*/
	function qodefInitPortfolioFeaturedScroll() {
		var qodefInitPortfolioFeaturedLinks = $('.qodef-portfolio-featured-content-inner');
		
		if (qodefInitPortfolioFeaturedLinks.length) {
			var qodefInitPortfolioFeaturedScrollInit = new PerfectScrollbar('.qodef-portfolio-featured-content-inner', {
				wheelSpeed: 0.6,
				suppressScrollX: true
			});
		}
	}
	
})(jQuery);