<?php
namespace BlommaCore\CPT\Shortcodes\SvgMorph;

use BlommaCore\Lib;

class SvgMorph implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_svg_morph';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                    => esc_html__( 'Svg Morph', 'blomma-core' ),
					'base'                    => $this->getBase(),
					'category'                => esc_html__( 'by BLOMMA', 'blomma-core' ),
					'icon'                    => 'icon-wpb-svg-morph-item extended-custom-icon',
					'show_settings_on_create' => true,
					'params'                  => array(
						array(
							'type' => 'textarea_raw_html',
							'param_name' => 'svg_source',
							'heading' => esc_html__('SVG Source', 'edgtf-core'),
							'description' => esc_html__( 'Paste the SVG code containing two <path> tags which will morph into one anothers "d" attribute.', 'blomma-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'positioning',
							'heading'     => esc_html__( ' Positioning', 'blomma-core' ),
							'value'       => array(
								esc_html__( 'Absolute', 'blomma-core' )  => 'absolute',
								esc_html__( 'Static', 'blomma-core' ) => 'static'
							),
							'save_always' => true,
							'description' => esc_html__( 'Absolute positioning offsets this shortcode in relation to parent Row element.', 'blomma-core' ),
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'horizontal_alignment',
							'heading'     => esc_html__( 'Horizontal Alignment', 'blomma-core' ),
							'value'       => array(
								esc_html__( 'Left', 'blomma-core' )  => 'left',
								esc_html__( 'Right', 'blomma-core' )  => 'right',
								esc_html__( 'Center', 'blomma-core' ) => 'center'
							),
							'save_always' => true,
							'dependency'  => array( 'element' => 'positioning', 'value' => array('absolute') )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'horizontal_offset',
							'heading'     => esc_html__( 'Horizontal Offset', 'blomma-core' ),
							'dependency'  => array( 'element' => 'positioning', 'value' => array('absolute') ),
							'description' => esc_html__( 'Offset can be entered in any value - px, %, vw etc. based on current position.', 'blomma-core' ),
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'vertical_alignment',
							'heading'     => esc_html__( 'Vertical Alignment', 'blomma-core' ),
							'value'       => array(
								esc_html__( 'Top', 'blomma-core' )  => 'top',
								esc_html__( 'Bottom', 'blomma-core' )  => 'bottom',
								esc_html__( 'Center', 'blomma-core' ) => 'center'
							),
							'save_always' => true,
							'dependency'  => array( 'element' => 'positioning', 'value' => array('absolute') )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'vertical_offset',
							'heading'     => esc_html__( 'Vertical Offset', 'blomma-core' ),
							'dependency'  => array( 'element' => 'positioning', 'value' => array('absolute') ),
							'description' => esc_html__( 'Offset can be entered in any value - px, %, vw etc. based on current position.', 'blomma-core' ),
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'animation_speed',
							'heading'     => esc_html__( 'Animation Speed', 'blomma-core' )
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'svg_source'       		=> '',
			'positioning'			=> '',
			'horizontal_alignment'  => '',
			'horizontal_offset'  	=> '',
			'vertical_alignment'  	=> '',
			'vertical_offset'  		=> '',
			'animation_speed'       => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['content']         	= $content;
		$params['holder_classes']	= $this->getHolderClasses( $params );
		$params['holder_styles']	= $this->getHolderStyles( $params );
		$params['holder_data']    	= $this->getHolderData( $params );
		
		$html = blomma_core_get_shortcode_module_template_part( 'templates/svg-morph-template', 'svg-morph', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['positioning'] ) ? 'qodef-'.$params['positioning'] : '';
		$holderClasses[] = ! empty( $params['vertical_alignment'] ) ? 'qodef-vertical-alignment-' . $params['vertical_alignment'] : '';
		$holderClasses[] = ! empty( $params['horizontal_alignment'] ) ? 'qodef-horizontal-alignment-' . $params['horizontal_alignment'] : '';
		
		return implode( ' ', $holderClasses );
	}

		
	private function getHolderStyles( $params ) {
		$styles = array();
		$x = '0px';
		$y = '0px';

		if ( $params['horizontal_offset'] !== '' ) {
			$x = $params['horizontal_offset'];
		}
		
		if ( $params['vertical_offset'] !== '' ) {
			$y = $params['vertical_offset'];
		}

		$styles[] = 'transform: translateX(' . $x . ') translateY('. $y .')';

		return implode( ';', $styles );
	}

	private function getHolderData( $params ) {
		$data = array();

		
		if ( ! empty( $params['animation_speed'] ) ) {
			$data['data-speed'] = $params['animation_speed'];
		}
		return $data;
	}
}
