<?php
/*----------------------------------------------------------------------------*\
	UTILS
\*----------------------------------------------------------------------------*/

if ( !class_exists( 'MPC_Utils' ) ) {
	class MPC_Utils {
		/* Add .httaccess rules */
		static function add_htaccess_rules() {
			if ( ! is_admin() ) {
				return;
			}

			$htaccess_file = ABSPATH . '.htaccess';

			if ( ! file_exists( $htaccess_file ) ) {
				return;
			}

			$rules = array(
				'<ifModule mod_substitute.c>',
				'SubstituteMaxLineLength 10M',
                '</ifModule>'
            );

            require_once( ABSPATH . 'wp-admin/includes/misc.php' );

            if ( function_exists( 'insert_with_markers' ) ) {
                insert_with_markers( $htaccess_file, 'Massive Addons by MPC', $rules );
            }
        }

        /* log_it */
        static function log_it( $message ) {
            if ( WP_DEBUG === true ) {
                if ( is_array( $message ) || is_object( $message ) ) {
                    error_log( print_r( $message, true ) );
                } else {
                    error_log( $message );
                }
            }
        }
	}
}