<?php
if($max_num_pages > 1) {
	$number_of_pages = $max_num_pages;
	$current_page    = $paged;
	$range           = 3;
	?>
	
	<div class="qodef-blog-pagination">
		<ul>
			<?php if($current_page > 2 && $current_page > $range && $range < $number_of_pages) { ?>
				<li class="qodef-pag-first">
					<a itemprop="url" href="<?php echo esc_url(get_pagenum_link(1)); ?>">
						<span class="arrow_carrot-2left"></span>
					</a>
				</li>
			<?php } ?>
			<?php if ($current_page > 1) { ?>
				<li class="qodef-pag-prev">
					<a itemprop="url" href="<?php echo esc_url(get_pagenum_link($current_page - 1)); ?>">
						<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
						     width="72px" height="14px" viewBox="0 0 72 14" enable-background="new 0 0 72 14" xml:space="preserve">
							<g>
								<defs>
									<rect id="SVGID_1_" width="72" height="14"/>
								</defs>
								<clipPath id="SVGID_2_">
									<use xlink:href="#SVGID_1_"  overflow="visible"/>
								</clipPath>
								<line clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-width="0.991" stroke-miterlimit="10" x1="71" y1="7" x2="1" y2="7"/>
								<polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-miterlimit="10" points="7.364,0.636 1,7 7.364,13.364"/>
							</g>
						</svg>
											</a>
				</li>
			<?php } ?>
			<?php for ($i=1; $i <= $number_of_pages; $i++) { ?>
				<?php if (!($i >= $current_page + $range+1 || $i <= $current_page - $range-1) || $number_of_pages <= $range ) { ?>
					<?php if($current_page == $i) { ?>
						<li class="qodef-pag-number qodef-pag-active">
							<a href="#"><?php echo esc_attr($i); ?></a>
						</li>
					<?php } else { ?>
						<li class="qodef-pag-number">
							<a itemprop="url" href="<?php echo get_pagenum_link($i); ?>"><?php echo esc_attr($i); ?></a>
						</li>
					<?php } ?>
				<?php } ?>
			<?php } ?>
			<?php if ($current_page < $number_of_pages) { ?>
				<li class="qodef-pag-next">
					<a itemprop="url" href="<?php echo esc_url(get_pagenum_link($current_page + 1)); ?>">
						<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="72px" height="14px" viewBox="0 0 72 14" enable-background="new 0 0 72 14" xml:space="preserve"><g><defs><rect id="SVGID_1_" width="72" height="14"/></defs><clipPath id="SVGID_2_"><use xlink:href="#SVGID_1_" overflow="visible"/></clipPath><line clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-width="0.991" stroke-miterlimit="10" x1="1" y1="7" x2="71" y2="7"/><polyline clip-path="url(#SVGID_2_)" fill="none" stroke="#231F20" stroke-miterlimit="10" points="64.636,0.636 71,7 	64.636,13.364"/></g></svg>
					</a>
				</li>
			<?php } ?>
			<?php if ($current_page + 1 < $number_of_pages && $current_page + $range-1 < $number_of_pages && $range < $number_of_pages) { ?>
				<li class="qodef-pag-last">
					<a itemprop="url" href="<?php echo esc_url(get_pagenum_link($number_of_pages)); ?>">
						<span class="arrow_carrot-2right"></span>
					</a>
				</li>
			<?php } ?>
		</ul>
	</div>
	
	<div class="qodef-blog-pagination-wp">
		<?php echo get_the_posts_pagination(); ?>
	</div>
	
	<?php
}