<?php

if ( class_exists( 'BlommaSelectClassWidget' ) ) {
	class BlommaSelectClassButtonWidget extends BlommaSelectClassWidget {
		public function __construct() {
			parent::__construct(
				'qodef_button_widget',
				esc_html__( 'Blomma Button Widget', 'blomma' ),
				array( 'description' => esc_html__( 'Add button element to widget areas', 'blomma' ) )
			);

			$this->setParams();
		}

		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'blomma' ),
					'options' => array(
						'solid'   => esc_html__( 'Solid', 'blomma' ),
						'outline' => esc_html__( 'Outline', 'blomma' ),
						'simple'  => esc_html__( 'Simple', 'blomma' )
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'size',
					'title'       => esc_html__( 'Size', 'blomma' ),
					'options'     => array(
						'small'  => esc_html__( 'Small', 'blomma' ),
						'medium' => esc_html__( 'Medium', 'blomma' ),
						'large'  => esc_html__( 'Large', 'blomma' ),
						'huge'   => esc_html__( 'Huge', 'blomma' )
					),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'blomma' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'text',
					'title'   => esc_html__( 'Text', 'blomma' ),
					'default' => esc_html__( 'Button Text', 'blomma' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'link',
					'title' => esc_html__( 'Link', 'blomma' )
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'target',
					'title'   => esc_html__( 'Link Target', 'blomma' ),
					'options' => blomma_select_get_link_target_array()
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'blomma' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'blomma' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'background_color',
					'title'       => esc_html__( 'Background Color', 'blomma' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'blomma' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_background_color',
					'title'       => esc_html__( 'Hover Background Color', 'blomma' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'blomma' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'border_color',
					'title'       => esc_html__( 'Border Color', 'blomma' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'blomma' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_border_color',
					'title'       => esc_html__( 'Hover Border Color', 'blomma' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'blomma' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'blomma' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'blomma' )
				)
			);
		}

		public function widget( $args, $instance ) {
			$params = '';

			if ( ! is_array( $instance ) ) {
				$instance = array();
			}

			// Filter out all empty params
			$instance = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );

			// Default values
			if ( ! isset( $instance['text'] ) ) {
				$instance['text'] = 'Button Text';
			}

			// Generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}

			echo '<div class="widget qodef-button-widget">';
			echo do_shortcode( "[qodef_button $params]" ); // XSS OK
			echo '</div>';
		}
	}
}