<?php

if ( class_exists( 'BlommaSelectClassWidget' ) ) {
	class BlommaSelectClassSeparatorWidget extends BlommaSelectClassWidget {
		public function __construct() {
			parent::__construct(
				'qodef_separator_widget',
				esc_html__( 'Blomma Separator Widget', 'blomma' ),
				array( 'description' => esc_html__( 'Add a separator element to your widget areas', 'blomma' ) )
			);

			$this->setParams();
		}

		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'blomma' ),
					'options' => array(
						'normal'     => esc_html__( 'Normal', 'blomma' ),
						'full-width' => esc_html__( 'Full Width', 'blomma' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'position',
					'title'   => esc_html__( 'Position', 'blomma' ),
					'options' => array(
						'center' => esc_html__( 'Center', 'blomma' ),
						'left'   => esc_html__( 'Left', 'blomma' ),
						'right'  => esc_html__( 'Right', 'blomma' )
					)
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'border_style',
					'title'   => esc_html__( 'Style', 'blomma' ),
					'options' => array(
						'solid'  => esc_html__( 'Solid', 'blomma' ),
						'dashed' => esc_html__( 'Dashed', 'blomma' ),
						'dotted' => esc_html__( 'Dotted', 'blomma' )
					)
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'blomma' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'width',
					'title' => esc_html__( 'Width (px or %)', 'blomma' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'thickness',
					'title' => esc_html__( 'Thickness (px)', 'blomma' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'top_margin',
					'title' => esc_html__( 'Top Margin (px or %)', 'blomma' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'bottom_margin',
					'title' => esc_html__( 'Bottom Margin (px or %)', 'blomma' )
				)
			);
		}

		public function widget( $args, $instance ) {
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}

			//prepare variables
			$params = '';

			//is instance empty?
			if ( is_array( $instance ) && count( $instance ) ) {
				//generate shortcode params
				foreach ( $instance as $key => $value ) {
					$params .= " $key='$value' ";
				}
			}

			echo '<div class="widget qodef-separator-widget">';
			echo do_shortcode( "[qodef_separator $params]" ); // XSS OK
			echo '</div>';
		}
	}
}