<?php

if ( ! function_exists( 'blomma_select_map_woocommerce_meta' ) ) {
	function blomma_select_map_woocommerce_meta() {
		
		$woocommerce_meta_box = blomma_select_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'blomma' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'blomma' ),
				'description' => esc_html__( 'Choose image layout when it appears in Select Product List - Masonry layout shortcode', 'blomma' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'blomma' ),
					'small'              => esc_html__( 'Small', 'blomma' ),
					'large-width'        => esc_html__( 'Large Width', 'blomma' ),
					'large-height'       => esc_html__( 'Large Height', 'blomma' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'blomma' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'blomma' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'blomma' ),
				'options'       => blomma_select_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'blomma' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'blomma' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_select_map_woocommerce_meta', 99 );
}