<?php
namespace BlommaCore\CPT\Shortcodes\InfoBox;

use BlommaCore\Lib;

class InfoBox implements Lib\ShortcodeInterface {
	private $base;
	
	public function __construct() {
		$this->base = 'qodef_info_box';
		
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                      => esc_html__( 'Info Box', 'blomma-core' ),
					'base'                      => $this->getBase(),
					'category'                  => esc_html__( 'by BLOMMA', 'blomma-core' ),
					'icon'                      => 'icon-wpb-info-box extended-custom-icon',
					'allowed_container_element' => 'vc_row',
					'params'                    => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'blomma-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'blomma-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'skin',
							'heading'     => esc_html__( 'Skin', 'blomma-core' ),
							'value'       => array(
								esc_html__( 'Default', 'blomma-core' ) => '',
								esc_html__( 'Light', 'blomma-core' )   => 'light',
							)
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'background_color',
							'heading'    => esc_html__( 'Background Color', 'blomma-core' )
						),
						array(
							'type'       => 'attach_image',
							'param_name' => 'background_image',
							'heading'    => esc_html__( 'Background Image', 'blomma-core' )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title',
							'heading'    => esc_html__( 'Title', 'blomma-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'title_tag',
							'heading'     => esc_html__( 'Title Tag', 'blomma-core' ),
							'value'       => array_flip( blomma_select_get_title_tag( true ) ),
							'save_always' => true,
							'dependency'  => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'title_color',
							'heading'    => esc_html__( 'Title Color', 'blomma-core' ),
							'dependency' => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'title_top_margin',
							'heading'    => esc_html__( 'Title Top Margin (px)', 'blomma-core' ),
							'dependency' => array( 'element' => 'title', 'not_empty' => true )
						),
						array(
							'type'       => 'textarea',
							'param_name' => 'text',
							'heading'    => esc_html__( 'Text', 'blomma-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'enable_border',
							'heading'     => esc_html__( 'Enable Border', 'blomma-core' ),
							'value'       => array_flip( blomma_select_get_yes_no_select_array( false, true ) ),
							'save_always' => true
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'text_color',
							'heading'    => esc_html__( 'Text Color', 'blomma-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true )
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'text_top_margin',
							'heading'    => esc_html__( 'Text Top Margin (px)', 'blomma-core' ),
							'dependency' => array( 'element' => 'text', 'not_empty' => true )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'button_text',
							'heading'     => esc_html__( 'Button Text', 'blomma-core' ),
							'value'       => esc_html__( '', 'blomma-core' ),
							'save_always' => true,
							'admin_label' => true
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'button_skin',
							'heading'    => esc_html__( 'Button Skin', 'blomma-core' ),
							'value'      => array(
								esc_html__( 'Default', 'blomma-core' ) => 'default',
								esc_html__( 'Light', 'blomma-core' )   => 'light',
								esc_html__( 'Dark', 'blomma-core' )    => 'dark'
							)
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'link',
							'heading'    => esc_html__( 'Link', 'blomma-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'target',
							'heading'     => esc_html__( 'Link Target', 'blomma-core' ),
							'value'       => array_flip( blomma_select_get_link_target_array() ),
							'save_always' => true
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'info_content_padding',
							'heading'     => esc_html__( 'Info Content Padding', 'blomma-core' ),
							'description' => esc_html__( 'Please insert padding in format top right bottom left', 'blomma-core' )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'animate',
							'heading'    => esc_html__( 'Enable Loading Animation', 'blomma-core' ),
							'value'      => array_flip( blomma_select_get_yes_no_select_array( false ) ),
							'group'      => esc_html__( 'Additional Features', 'blomma-core' )
						),
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'        => '',
			'custom_link'         => '',
			'custom_link_target'  => '_self',
			'skin'                => '',
			'background_color'    => '',
			'background_image'    => '',
			'title'               => '',
			'title_tag'           => 'h3',
			'title_color'         => '',
			'title_top_margin'    => '',
			'text'                => '',
			'enable_border'       => '',
			'text_color'          => '',
			'text_top_margin'     => '',
			'button_text'         => '',
			'button_skin'         => 'default',
			'link'                => '',
			'target'              => '_self',
			'info_content_padding'=> '',
			'animate'			  => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['holder_classes']     = $this->getHolderClasses( $params );
		$params['holder_button_classes']     = $this->getButtonClasses( $params );
		$params['custom_link_target'] = ! empty( $params['custom_link_target'] ) ? $params['custom_link_target'] : $args['custom_link_target'];
		$params['title_tag']          = ! empty( $params['title_tag'] ) ? $params['title_tag'] : $args['title_tag'];
		$params['title_styles']       = $this->getTitleStyles( $params );
		$params['text_styles']        = $this->getTextStyles( $params );
		$params['content_styles']        = $this->getContentStyles( $params );
		$params['bg_styles']   = $this->getBgStyles( $params );
		$params['link']   = ! empty( $params['link'] ) ? $params['link'] : '#';
		$params['target'] = ! empty( $params['target'] ) ? $params['target'] : $args['target'];
		
		
		$html = blomma_core_get_shortcode_module_template_part( 'templates/info-box', 'info-box', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['skin'] ) ? 'qodef-' . esc_attr( $params['skin'] ) . '-skin' : '';
		$holderClasses[] = $params['animate'] == 'yes' ? 'qodef-loading-animation' : '';
		
		if ( $params['enable_border'] == 'no' )  {
			
			$holderClasses[] = 'qodef-disabled-border';
		}
		
		return implode( ' ', $holderClasses );
	}
	
	private function getTitleStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['title_color'] ) ) {
			$styles[] = 'color: ' . $params['title_color'];
		}
		
		if ( $params['title_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . blomma_select_filter_px( $params['title_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getTextStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['text_color'] ) ) {
			$styles[] = 'color: ' . $params['text_color'];
		}
		
		if ( $params['text_top_margin'] !== '' ) {
			$styles[] = 'margin-top: ' . blomma_select_filter_px( $params['text_top_margin'] ) . 'px';
		}
		
		return implode( ';', $styles );
	}
	
	private function getButtonClasses( $params ) {
		$holderButtonClasses = array();
		
		$holderButtonClasses[] = ! empty( $params['button_skin'] ) ? 'qodef-' . esc_attr( $params['button_skin'] ) . '-skin' : '';
		
		return implode( ' ', $holderButtonClasses );
	}
	
	private function getContentStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['info_content_padding'] ) ) {
			$styles[] = 'padding: ' . $params['info_content_padding'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getBgStyles( $params ) {
		$styles = array();

		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}
		
		if ( ! empty( $params['background_image'] ) ) {
			$styles[] = 'background-image: url(' . wp_get_attachment_url( $params['background_image'] ) . ')';
		}
		
		return implode( ';', $styles );
	}
}