<?php

if ( ! function_exists( 'blomma_core_map_portfolio_settings_meta' ) ) {
	function blomma_core_map_portfolio_settings_meta() {
		$meta_box = blomma_select_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'blomma-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		blomma_select_create_meta_box_field( array(
			'name'        => 'qodef_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'blomma-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'blomma-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'blomma-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'blomma-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'blomma-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'blomma-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'blomma-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'blomma-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'blomma-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'blomma-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'blomma-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'blomma-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'blomma-core' ),
				'split-screen'      => esc_html__( 'Portfolio Split Screen','blomma-core'),
				'full-screen-slider' => esc_html__('Portfolio Full Screen Slider','blomma-core'),
				'content-top-with-info' => esc_html__( 'Portfolio Content Top With Additional Info', 'blomma-core' ),
				'info-before'       => esc_html__( 'Info Before', 'blomma-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'blomma-core' )
			)
		) );
		
		$info_content_meta_container = blomma_select_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'qodef_info_content_container',
				'dependency' => array(
					'show' => array(
						'qodef_portfolio_single_template_meta'  => array(
							'',
							'huge-images',
							'content-top-with-info',
							'info-before'
						)
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field( array(
			'name'        => 'qodef_portfolio_single_info_content',
			'type'        => 'textarea',
			'label'       => esc_html__( 'Portfolio Info Content', 'blomma-core' ),
			'description' => esc_html__( 'Enter portfolio info content', 'blomma-core' ),
			'parent'      => $info_content_meta_container
		) );
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = blomma_select_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'qodef_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'qodef_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'blomma-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'blomma-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => blomma_select_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'blomma-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'blomma-core' ),
				'default_value' => '',
				'options'       => blomma_select_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = blomma_select_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'qodef_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'qodef_portfolio_single_template_meta'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'blomma-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'blomma-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => blomma_select_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'blomma-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'blomma-core' ),
				'default_value' => '',
				'options'       => blomma_select_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'blomma-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'blomma-core' ),
				'parent'        => $meta_box,
				'options'       => blomma_select_get_yes_no_select_array()
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'blomma-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'blomma-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'blomma-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'blomma-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'blomma-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'blomma-core' ),
				'parent'      => $meta_box
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'blomma-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'blomma-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'blomma-core' ),
					'small'              => esc_html__( 'Small', 'blomma-core' ),
					'large-width'        => esc_html__( 'Large Width', 'blomma-core' ),
					'large-height'       => esc_html__( 'Large Height', 'blomma-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'blomma-core' )
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'blomma-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'blomma-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''            => esc_html__( 'Default', 'blomma-core' ),
					'large-width' => esc_html__( 'Large Width', 'blomma-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		blomma_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'blomma-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'blomma-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
		
		blomma_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_masonry_original_padding_meta',
				'type'          => 'text',
				'label'         => esc_html__( 'Padding for Masonry - Image Original Proportion (%)', 'blomma-core' ),
				'description'   => esc_html__( 'Choose item padding when it appears in Masonry type portfolio lists where image proportion is original', 'blomma-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);

		blomma_select_create_meta_box_field(
			array(
				'name'        => 'qodef_portfolio_overlay_color_meta',
				'type'        => 'color',
				'label'       => esc_html__( 'Gallery Overlay Color', 'blomma-core' ),
				'description' => esc_html__( 'This option will take effect on Portfolio Lists that have Overlay Skin set to Item-Based.', 'blomma-core' ),
				'parent'      => $meta_box
			)
		);
	}
	
	add_action( 'blomma_select_action_meta_boxes_map', 'blomma_core_map_portfolio_settings_meta', 41 );
}